/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.i18n;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Locale;
import lombok.Generated;
import nz.org.riskscape.engine.i18n.MessageFactory;
import nz.org.riskscape.engine.i18n.MessageKey;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.RiskscapeMessage;

public class MessageFactoryProxy
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private final Locale locale;
    private final MessageSource messageSource;

    public static <T extends MessageFactory> T getMessageFactory(Class<T> factory, Locale locale, MessageSource messageSource) {
        return (T)((MessageFactory)Proxy.newProxyInstance(factory.getClassLoader(), new Class[]{factory}, (InvocationHandler)new MessageFactoryProxy(locale, messageSource)));
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        String messageCode = method.getDeclaringClass().getCanonicalName() + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, method.getName());
        if (args == null) {
            args = NO_ARGS;
        }
        String defaultMessage = this.methodNameToMessage(method.getName());
        if (method.getReturnType().equals(MessageKey.class)) {
            return RiskscapeMessage.withDefault((String)messageCode, (String)defaultMessage, (Object[])args);
        }
        if (method.getReturnType().equals(String.class)) {
            return this.messageSource.getMessage(messageCode, args, defaultMessage, this.locale);
        }
        throw new RuntimeException(String.valueOf(method) + " must return a String or a MessageKey");
    }

    private String methodNameToMessage(String methodName) {
        return ((String)CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.LOWER_UNDERSCORE).convert((Object)methodName)).replace('_', ' ');
    }

    @Generated
    public MessageFactoryProxy(Locale locale, MessageSource messageSource) {
        this.locale = locale;
        this.messageSource = messageSource;
    }
}

