/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Type;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.GeometryCollector;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.measure.Units;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class GeometryUtils {
    public static final double METRES_PER_NAUTICAL_MILE = Units.NAUTICAL_MILE.getConverterTo(Units.METRE).convert(1.0);
    public static final double METRES_PER_DEGREE = METRES_PER_NAUTICAL_MILE * 60.0;

    public static void processPerPart(Geometry geom, Consumer<Geometry> processor) {
        if (geom instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geom;
            for (int i = 0; i < collection.getNumGeometries(); ++i) {
                Geometry part = collection.getGeometryN(i);
                processor.accept(part);
            }
        } else {
            processor.accept(geom);
        }
    }

    public static double toCrsUnits(double linealMetres, CoordinateReferenceSystem crs) {
        double lineal = linealMetres;
        Unit crsUnit = crs.getCoordinateSystem().getAxis(0).getUnit();
        if (crsUnit.equals(Units.DEGREE_ANGLE)) {
            lineal = linealMetres / METRES_PER_DEGREE;
        } else if (!crsUnit.equals(Units.METRE)) {
            Unit lengthUnit = crsUnit.asType(Length.class);
            UnitConverter metresToCrsUnit = Units.METRE.getConverterTo(lengthUnit);
            lineal = metresToCrsUnit.convert(linealMetres);
        }
        return lineal;
    }

    public static boolean equivalentTypes(Geometry g1, Geometry g2) {
        return GeometryFamily.fromClass(g1.getClass()) == GeometryFamily.fromClass(g2.getClass());
    }

    public static double distanceToCrsUnits(double distance, Geometry geom, SRIDSet sridSet) {
        CoordinateReferenceSystem crs = sridSet.get(geom.getSRID());
        return GeometryUtils.toCrsUnits(distance, crs);
    }

    public static boolean canReprojectSafely(Type sourceGeomType, Type targetGeomType) {
        return Nullable.strip((Type)sourceGeomType).find(Referenced.class).map(sourceReferenced -> Nullable.strip((Type)targetGeomType).find(Referenced.class).map(toRef -> {
            if (CRS.equalsIgnoreMetadata((Object)sourceReferenced.getCrs(), (Object)toRef.getCrs())) {
                return false;
            }
            try {
                if (CRS.lookupIdentifier((IdentifiedObject)toRef.getCrs(), (boolean)false).equals("EPSG:4326")) {
                    return true;
                }
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
            ReferencedEnvelope sourceBounds = sourceReferenced.getBounds();
            if (sourceBounds == null) {
                return false;
            }
            try {
                ReferencedEnvelope transformed = sourceBounds.transform(toRef.getCrs(), true);
                ReferencedEnvelope targetBounds = GeometryUtils.toBounds(toRef.getCrs());
                if (targetBounds != null) {
                    return targetBounds.contains((Envelope)transformed);
                }
                return false;
            }
            catch (FactoryException | TransformException t) {
                return false;
            }
        }).orElse(false)).orElse(false);
    }

    private static ReferencedEnvelope toBounds(CoordinateReferenceSystem crs) {
        Bounds targetEnv = CRS.getEnvelope((CoordinateReferenceSystem)crs);
        if (targetEnv != null) {
            return new ReferencedEnvelope(targetEnv.getMinimum(0), targetEnv.getMaximum(0), targetEnv.getMinimum(1), targetEnv.getMaximum(1), crs);
        }
        try {
            CoordinateReferenceSystem noForce = CRS.decode((String)CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false), (boolean)false);
            targetEnv = CRS.getEnvelope((CoordinateReferenceSystem)noForce);
            if (targetEnv != null) {
                ReferencedEnvelope transformedEnv = new ReferencedEnvelope(targetEnv.getMinimum(0), targetEnv.getMaximum(0), targetEnv.getMinimum(1), targetEnv.getMaximum(1), noForce);
                return transformedEnv.transform(crs, true);
            }
        }
        catch (FactoryException | TransformException throwable) {
            // empty catch block
        }
        return null;
    }

    public static Geometry removeNonFamilyMembers(Geometry geom, GeometryFamily expectedGeomFamily) {
        if (!(geom instanceof GeometryCollection)) {
            if (expectedGeomFamily.isSameFamily(geom)) {
                return geom;
            }
            return GeometryUtils.emptyGeom(expectedGeomFamily, geom.getFactory());
        }
        ArrayList parts = new ArrayList();
        GeometryUtils.processPerPart(geom, part -> {
            if (expectedGeomFamily.isSameFamily(part)) {
                parts.add(part);
            }
        });
        if (parts.isEmpty()) {
            return GeometryUtils.emptyGeom(expectedGeomFamily, geom.getFactory());
        }
        if (parts.size() == 1) {
            return (Geometry)parts.get(0);
        }
        GeometryCollector collector = new GeometryCollector();
        collector.setFactory(geom.getFactory());
        parts.stream().forEach(part -> collector.add(part));
        return collector.collect();
    }

    public static Optional<Point> getMidpoint(Geometry geom) {
        Point mid;
        if (geom instanceof Point) {
            Point point = (Point)geom;
            return Optional.of(point);
        }
        if (geom instanceof LineString) {
            LineString line = (LineString)geom;
            double length = line.getLength();
            double midLength = length / 2.0;
            double travelled = 0.0;
            for (int i = 0; i < line.getNumPoints() - 1; ++i) {
                LineSegment segment = new LineSegment(line.getPointN(i).getCoordinate(), line.getPointN(i + 1).getCoordinate());
                double segmentLength = segment.getLength();
                if (travelled + segmentLength > midLength) {
                    Coordinate mid2 = segment.pointAlong((midLength - travelled) / segmentLength);
                    return Optional.of(new Point(geom.getFactory().getCoordinateSequenceFactory().create(new Coordinate[]{mid2}), geom.getFactory()));
                }
                travelled += segment.getLength();
            }
        }
        if (geom.contains((Geometry)(mid = geom.getCentroid()))) {
            return Optional.of(mid);
        }
        return Optional.empty();
    }

    private static Geometry emptyGeom(GeometryFamily family, GeometryFactory factory) {
        switch (family) {
            case PUNTAL: {
                return factory.createPoint();
            }
            case LINEAL: {
                return factory.createLineString();
            }
            case POLYGONAL: {
                return factory.createPolygon();
            }
        }
        throw new RuntimeException("Unknown geometry family " + String.valueOf(family));
    }
}

