/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.data.InputDataProblems;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.eqrule.PartialStructRule;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;

public abstract class UserDefinedFunction
implements RealizableFunction {
    private final FunctionMetadata metadata;
    private final Resource script;
    private IdentifiedFunction identified;

    public UserDefinedFunction(FunctionMetadata details, Resource script) {
        this.metadata = details;
        this.script = script;
    }

    public List<Type> getDeclaredArgumentTypes() {
        return this.metadata.getArguments().getArgumentTypes();
    }

    public boolean areArgumentsCompatible(RealizationContext context, List<Type> givenArgs) {
        return this.metadata.getArguments().isCompatible(context, givenArgs);
    }

    public List<Problem> getArgumentProblems(RealizationContext context, List<Type> givenArgs) {
        return this.metadata.getArguments().getProblems(context, givenArgs, (expected, given) -> this.describeMismatch(context, (FunctionArgument)expected, (Type)given));
    }

    private List<Problem> describeMismatch(RealizationContext context, FunctionArgument expectedArg, Type given) {
        TypeSet typeset = context.getProject().getTypeSet();
        Problem mismatch = ArgsProblems.mismatch((FunctionArgument)expectedArg, (Type)given);
        Optional expectedStructOr = expectedArg.getType().find(Struct.class);
        Optional givenStructOr = given.find(Struct.class);
        if (expectedStructOr.isPresent() && givenStructOr.isPresent()) {
            mismatch = mismatch.withChildren(this.describeMismatch(typeset, (Struct)givenStructOr.get(), (Struct)expectedStructOr.get()));
        }
        return Arrays.asList(mismatch);
    }

    private List<Problem> describeMismatch(TypeSet typeset, Struct given, Struct expected) {
        List problems = PartialStructRule.describeMismatch((TypeSet)typeset, (Struct)given, (Struct)expected);
        if (!problems.isEmpty()) {
            problems.add(InputDataProblems.get().doesNotMatchType());
        }
        return problems;
    }

    public IdentifiedFunction identified() {
        if (this.identified == null) {
            this.identified = RealizableFunction.identified((RealizableFunction)this, (FunctionMetadata)this.metadata);
        }
        return this.identified;
    }

    @Generated
    public FunctionMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public Resource getScript() {
        return this.script;
    }
}

