/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionMetadata;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.types.Type;

public class MetadataParams {
    private static final String LOCATION_KEY = "location";
    @ParameterField
    public Optional<URI> location;
    @ParameterField
    public Optional<ConfigString> source;
    @ParameterField
    public Type returnType;
    @ParameterField(scalarOverride=true)
    public ArgumentList argumentTypes;
    @ParameterField
    public Optional<String> description = Optional.empty();
    @ParameterField
    public Optional<IdentifiedFunction.Category> category = Optional.empty();
    @ParameterField
    public Optional<String> framework = Optional.empty();

    public static boolean locationEndsWith(Map<String, List<?>> unbound, String suffix) {
        List locationValues = unbound.getOrDefault(LOCATION_KEY, Collections.emptyList());
        if (!locationValues.isEmpty()) {
            String location = (String)locationValues.get(0);
            return location.endsWith(suffix);
        }
        return false;
    }

    public FunctionMetadata toFunctionMetadata(String functionName) {
        return new FunctionMetadata(functionName, this.argumentTypes, this.returnType, this.description.orElse(""), this.category.orElse(FunctionMetadata.UNCATEGORIZED), this.location.orElse(this.source.map(ConfigString::getLocation).orElse(Resource.UNKNOWN_URI)));
    }
}

