/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.function.MetadataParams;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.StringResource;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public interface FunctionFrameworkSupport {
    default public ResultOrProblems<Resource> loadFunctionFromParams(Engine engine, MetadataParams params) {
        if (params.location.isPresent() == params.source.isPresent()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ParamProblems.oneOfTheseRequired((String[])new String[]{"location", "source"})});
        }
        try {
            if (params.location.isPresent()) {
                return ResultOrProblems.of((Object)engine.getResourceFactory().load(params.location.get()));
            }
        }
        catch (ResourceLoadingException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)ex)});
        }
        return ResultOrProblems.of((Object)((Object)StringResource.fromConfig(params.source.get())));
    }
}

