/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.Lambda;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class MappedCoverage
implements TypedCoverage {
    private final TypedCoverage mapped;
    private final RealizedExpression mappingExpression;
    private final String valueName;
    private final Tuple originalScope;

    public static ResultOrProblems<TypedCoverage> build(RealizationContext context, TypedCoverage wrapping, String valueName, Expression expression) {
        Struct scope = Struct.of((String)valueName, (Type)wrapping.getType());
        return ProblemException.catching(() -> new MappedCoverage(wrapping, (RealizedExpression)context.getExpressionRealizer().realize((Type)scope, expression).getOrThrow(), valueName));
    }

    public static ResultOrProblems<TypedCoverage> build(RealizationContext context, TypedCoverage wrapping, Lambda lambda) {
        return MappedCoverage.build(context, wrapping, ((Token)lambda.getArguments().get(0)).getValue(), lambda.getExpression());
    }

    private static Tuple lambdaOnlyScope(RealizedExpression expression) {
        Object placeholder = null;
        return Tuple.ofValues((Struct)((Struct)expression.getInputType()), (Object[])new Object[]{placeholder});
    }

    public MappedCoverage(TypedCoverage coverage, RealizedExpression expression, String valueName) {
        this(coverage, expression, valueName, MappedCoverage.lambdaOnlyScope(expression));
    }

    public Type getType() {
        return this.mappingExpression.getResultType();
    }

    public Object evaluate(Point point) {
        return this.map(this.mapped.evaluate(point));
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        return this.mapped.getEnvelope();
    }

    public Optional<Function<Geometry, List<Pair<Geometry, Object>>>> getEvaluateIntersectionOp() {
        return this.mapped.getEvaluateIntersectionOp().map((? super T op) -> op.andThen(list -> Lists.transform((List)list, pair -> Pair.of((Object)((Geometry)pair.getLeft()), (Object)this.map(pair.getRight())))));
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.mapped.getCoordinateReferenceSystem();
    }

    private Object map(Object rawResult) {
        if (rawResult == null && !this.mapped.getType().isNullable()) {
            return null;
        }
        Tuple scope = this.originalScope.clone();
        scope.set(this.valueName, rawResult);
        return this.mappingExpression.evaluate((Object)scope);
    }

    public String toString() {
        return String.format("Mapped(%s, %s)", this.mapped, this.mappingExpression.getExpression().toSource());
    }

    @Generated
    public MappedCoverage(TypedCoverage mapped, RealizedExpression mappingExpression, String valueName, Tuple originalScope) {
        this.mapped = mapped;
        this.mappingExpression = mappingExpression;
        this.valueName = valueName;
        this.originalScope = originalScope;
    }

    @Generated
    public TypedCoverage getMapped() {
        return this.mapped;
    }

    @Generated
    public RealizedExpression getMappingExpression() {
        return this.mappingExpression;
    }

    @Generated
    public String getValueName() {
        return this.valueName;
    }

    @Generated
    public Tuple getOriginalScope() {
        return this.originalScope;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MappedCoverage)) {
            return false;
        }
        MappedCoverage other = (MappedCoverage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypedCoverage this$mapped = this.getMapped();
        TypedCoverage other$mapped = other.getMapped();
        if (this$mapped == null ? other$mapped != null : !this$mapped.equals(other$mapped)) {
            return false;
        }
        RealizedExpression this$mappingExpression = this.getMappingExpression();
        RealizedExpression other$mappingExpression = other.getMappingExpression();
        if (this$mappingExpression == null ? other$mappingExpression != null : !this$mappingExpression.equals(other$mappingExpression)) {
            return false;
        }
        String this$valueName = this.getValueName();
        String other$valueName = other.getValueName();
        if (this$valueName == null ? other$valueName != null : !this$valueName.equals(other$valueName)) {
            return false;
        }
        Tuple this$originalScope = this.getOriginalScope();
        Tuple other$originalScope = other.getOriginalScope();
        return !(this$originalScope == null ? other$originalScope != null : !this$originalScope.equals(other$originalScope));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MappedCoverage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypedCoverage $mapped = this.getMapped();
        result = result * 59 + ($mapped == null ? 43 : $mapped.hashCode());
        RealizedExpression $mappingExpression = this.getMappingExpression();
        result = result * 59 + ($mappingExpression == null ? 43 : $mappingExpression.hashCode());
        String $valueName = this.getValueName();
        result = result * 59 + ($valueName == null ? 43 : $valueName.hashCode());
        Tuple $originalScope = this.getOriginalScope();
        result = result * 59 + ($originalScope == null ? 43 : $originalScope.hashCode());
        return result;
    }
}

