/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public final class ResolvedBookmarkImpl<T extends BookmarkParameters>
implements ResolvedBookmark {
    @NonNull
    protected final BaseBookmarkResolver<T> resolver;
    protected final T paramsObject;
    private ResultOrProblems<Object> built;

    public ResolvedBookmarkImpl(BaseBookmarkResolver<T> resolver, T paramsObject) {
        this.resolver = resolver;
        this.paramsObject = paramsObject;
    }

    public Bookmark getBookmark() {
        return ((BookmarkParameters)this.paramsObject).bookmark;
    }

    public <X> Optional<ResultOrProblems<X>> getIfType(Class<X> requiredType) {
        if (requiredType.isAssignableFrom(((BookmarkParameters)this.paramsObject).getDataType())) {
            return Optional.of(this.build().map(b -> requiredType.cast(b)));
        }
        return Optional.empty();
    }

    protected ResultOrProblems<Object> build() {
        if (this.hasValidationErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"There are validation problems with this bookmark preventing it from being opened", (Object[])new Object[0])});
        }
        if (this.built == null) {
            try {
                this.built = this.resolver.build(this.paramsObject);
            }
            catch (RuntimeException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
            }
        }
        return this.built;
    }

    public Type getScalarType() {
        return ((BookmarkParameters)this.paramsObject).getScalarType(this);
    }

    public String toString() {
        return String.format("%s(format=%s, location=%s)", ((BookmarkParameters)this.paramsObject).bookmark.getId(), this.resolver.getFormat(((BookmarkParameters)this.paramsObject).bookmark), ((BookmarkParameters)this.paramsObject).bookmark.getLocation());
    }

    public List<Problem> validate() {
        return ((BookmarkParameters)this.paramsObject).problems;
    }

    public Class<?> getDataType() {
        return ((BookmarkParameters)this.paramsObject).getDataType();
    }

    @Generated
    public T getParamsObject() {
        return this.paramsObject;
    }
}

