/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.ResolvedBookmarkImpl;
import nz.org.riskscape.engine.data.SelfDescribingScalarData;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;

public abstract class BookmarkParameters {
    @ParameterField
    public URI location;
    @ParameterField
    public Optional<String> format = Optional.empty();
    @ParameterField
    public Optional<String> description = Optional.empty();
    @ParameterField
    public Optional<String> requiresSecret = Optional.empty();
    public final List<Problem> problems = new ArrayList<Problem>();
    public Bookmark bookmark;
    public BindingContext bindingContext;
    public Optional<File> validatedFile;

    public ExpressionRealizer getExpressionRealizer() {
        return this.bindingContext.getRealizationContext().getExpressionRealizer();
    }

    public RealizationContext getRealizationContext() {
        return this.bindingContext.getRealizationContext();
    }

    public void add(Problem problem) {
        this.problems.add(problem);
    }

    public URI getLocation() {
        return this.bookmark.getLocation();
    }

    public abstract Class<?> getDataType();

    public Type getScalarType(ResolvedBookmarkImpl<?> resolved) {
        return (Type)resolved.getData(Object.class).map(obj -> (Type)SelfDescribingScalarData.getScalarDataType((Object)obj).orElse(Types.ANYTHING)).orElse((Object)Types.NOTHING);
    }

    public Path getBookmarkedPath() {
        if (this.validatedFile != null && this.validatedFile.isPresent()) {
            return this.validatedFile.map(f -> f.toPath()).get();
        }
        Resource resource = this.bindingContext.getEngine().getResourceFactory().load(this.getLocation());
        return BaseBookmarkResolver.resourceToPath(resource, this.bindingContext);
    }

    public Project getProject() {
        return this.getRealizationContext().getProject();
    }
}

