/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeIOException;
import nz.org.riskscape.engine.auth.HttpSecret;
import nz.org.riskscape.engine.auth.Secret;
import nz.org.riskscape.engine.auth.SecretBuilders;
import nz.org.riskscape.engine.auth.SecretProblems;
import nz.org.riskscape.engine.auth.Secrets;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundJavaParameters;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.BookmarkResolver;
import nz.org.riskscape.engine.data.ResolvedBookmark;
import nz.org.riskscape.engine.data.ResolvedBookmarkImpl;
import nz.org.riskscape.engine.geo.PrjParser;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.UriHelper;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.PrjFileReader;
import org.geotools.referencing.CRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBookmarkResolver<T extends BookmarkParameters>
implements BookmarkResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseBookmarkResolver.class);
    private final JavaParameterSet<T> parameterSet;
    protected final Engine engine;

    public static void setCrs(BookmarkParameters params, String crsName, boolean longitudeFirst, Parameter param, Consumer<CoordinateReferenceSystem> crs) {
        try {
            crs.accept(CRS.decode((String)crsName, (boolean)longitudeFirst));
        }
        catch (NoSuchAuthorityCodeException e) {
            params.problems.add(GeometryProblems.get().unknownCrsCode(crsName));
        }
        catch (FactoryException e) {
            params.problems.add(Problem.error((ProblemCode)ProblemCodes.USER_DEFINED_CRS_ERROR, (Object[])new Object[]{crsName, e.getMessage()}).affecting((Object)param));
        }
    }

    public BaseBookmarkResolver(Engine engine) {
        this.engine = engine;
        this.parameterSet = this.buildParameterSet();
    }

    public Optional<ResolvedBookmark> resolve(Bookmark bookmark, BindingContext context) {
        String format = this.getFormat(bookmark);
        if (format == null || !this.getFormats().contains(format)) {
            return Optional.empty();
        }
        T paramsObject = this.bindAndValidate(bookmark, context);
        return Optional.of(this.newResolved(paramsObject));
    }

    public String getFormat(Bookmark bookmark) {
        URI uri = bookmark.getLocation();
        String format = bookmark.getFormat();
        if (Strings.isNullOrEmpty((String)format)) {
            String file = uri.getPath();
            if (file == null) {
                return format;
            }
            for (String extension : this.getExtensionsToFormats().keySet()) {
                if (!file.endsWith("." + extension)) continue;
                format = this.getExtensionsToFormats().get(extension);
            }
        }
        return format;
    }

    protected ResolvedBookmark newResolved(T parameters) {
        if (((BookmarkParameters)parameters).bookmark == null) {
            throw new NullPointerException("parameters.bookmark can not be null");
        }
        if (((BookmarkParameters)parameters).bindingContext == null) {
            throw new NullPointerException("parameters.bindingContext can not be null");
        }
        return new ResolvedBookmarkImpl<T>(this, parameters);
    }

    protected abstract Map<String, String> getExtensionsToFormats();

    public Set<String> getFormats() {
        return new HashSet<String>(this.getExtensionsToFormats().values());
    }

    public List<String> getExtensions(String format) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.getExtensionsToFormats().entrySet()) {
            if (!format.equals(entry.getValue())) continue;
            extensions.add(entry.getKey());
        }
        return extensions;
    }

    protected final T bindAndValidate(Bookmark bookmark, BindingContext context) {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        Map unparsed = bookmark.getParamMap();
        Map<String, List<?>> mapped = this.findMapishOptions(unparsed, problems);
        mapped = this.convertAliases(mapped, problems);
        BoundParameters bound = this.parameterSet.bind(context, mapped);
        BoundJavaParameters<T> boundObj = this.parameterSet.bindToObject(bound);
        BookmarkParameters paramsObject = (BookmarkParameters)boundObj.getBoundToObject();
        paramsObject.bookmark = bookmark;
        paramsObject.bindingContext = context;
        paramsObject.problems.addAll(bound.getValidationProblems());
        paramsObject.problems.addAll(problems);
        this.findUnusedParameters(paramsObject, mapped, context);
        this.applyFile(paramsObject);
        this.validateParameters(paramsObject, context);
        this.validateCommonParameters(paramsObject, context);
        return (T)paramsObject;
    }

    private void applyFile(T paramsObject) {
        URI location = ((BookmarkParameters)paramsObject).getLocation();
        if ("file".equals(location.getScheme())) {
            File file = new File(location.getPath());
            this.checkFile(paramsObject, file);
            ((BookmarkParameters)paramsObject).validatedFile = Optional.of(file);
        }
    }

    private void findUnusedParameters(T memo, Map<String, ?> unparsed, BindingContext context) {
        Set expectedNames = this.parameterSet.getDeclared().stream().map(Parameter::getName).collect(Collectors.toSet());
        Set<String> givenNames = unparsed.keySet();
        Sets.SetView difference = Sets.difference(givenNames, expectedNames);
        if (!difference.isEmpty()) {
            ((BookmarkParameters)memo).problems.add(Problem.warning((String)"Unrecognized parameters given - %s - these will be ignored", (Object[])new Object[]{difference}));
        }
    }

    Map<String, List<?>> findMapishOptions(Map<String, List<?>> unparsed, List<Problem> problems) {
        HashMap withMaps = new HashMap();
        for (Map.Entry<String, List<?>> entry : unparsed.entrySet()) {
            String key = entry.getKey();
            List<?> values = entry.getValue();
            String[] splitKey = key.split(Pattern.quote("."), 2);
            if (splitKey.length == 2) {
                String keyPrefix = splitKey[0];
                String keySuffix = splitKey[1];
                Map nestedMap = (Map)withMaps.computeIfAbsent(keyPrefix, k -> Arrays.asList(new HashMap())).get(0);
                if (values.size() > 1) {
                    problems.add(ParamProblems.get().wrongNumberGiven(key, "1", values.size()));
                }
                nestedMap.put(keySuffix, values.get(values.size() - 1));
                continue;
            }
            withMaps.put(key, values);
        }
        return withMaps;
    }

    private Map<String, List<?>> convertAliases(Map<String, List<?>> unparsed, List<Problem> addTo) {
        HashMap convertedParams = new HashMap();
        Map<String, String> aliases = this.getAliasMapping();
        for (Map.Entry<String, List<?>> userValue : unparsed.entrySet()) {
            String newParamName = aliases.get(userValue.getKey());
            if (newParamName == null) {
                convertedParams.put(userValue.getKey(), userValue.getValue());
                continue;
            }
            if (unparsed.containsKey(newParamName)) {
                addTo.add(((ParamProblems)Problems.get(ParamProblems.class)).mutuallyExclusive(newParamName, userValue.getKey()));
                continue;
            }
            convertedParams.put(newParamName, userValue.getValue());
        }
        return convertedParams;
    }

    protected void validateCommonParameters(T parameters, BindingContext context) {
        SecretProblems secretProblems = (SecretProblems)Problems.get(SecretProblems.class);
        if (((BookmarkParameters)parameters).requiresSecret.isPresent()) {
            Secrets secrets;
            Optional<HttpSecret> found;
            String secretsFramework = ((BookmarkParameters)parameters).requiresSecret.get();
            ResultOrProblems problemsOr = ((SecretBuilders)this.engine.getCollection(SecretBuilders.class)).getOr(secretsFramework);
            if (problemsOr.hasProblems()) {
                ((BookmarkParameters)parameters).add(Problems.foundWith((Object)this.getParameterSet().get("requires-secret"), (List)problemsOr.getProblems()));
                return;
            }
            if (context.getEngine().hasCollectionOf(Secret.class) && !(found = (secrets = (Secrets)this.engine.getCollection(Secrets.class)).getOfType(HttpSecret.class).stream().filter(s -> s.matches(parameters.location) && s.getFramework().equals(secretsFramework)).findFirst()).isPresent()) {
                ((BookmarkParameters)parameters).add(secretProblems.requiredNotFound(secretsFramework, ((BookmarkParameters)parameters).getLocation().getHost(), secretProblems.noSecretsHint(Secrets.getUserHomeSecrets((Engine)this.engine))));
            }
        }
    }

    protected void validateParameters(T parameters, BindingContext context) {
    }

    protected JavaParameterSet<T> buildParameterSet() {
        return JavaParameterSet.fromBindingClass(this.getParamsClass());
    }

    protected Class<T> getParamsClass() {
        return ReflectionUtils.findParameterClass(this.getClass());
    }

    protected Map<String, String> getAliasMapping() {
        return Collections.emptyMap();
    }

    protected abstract ResultOrProblems build(T var1);

    protected void checkFile(T paramsObject, File file) {
        if (!file.exists()) {
            ((BookmarkParameters)paramsObject).add(Problem.error((String)"File '%s' does not exist", (Object[])new Object[]{file}));
        }
        if (file.exists() && !file.canRead()) {
            ((BookmarkParameters)paramsObject).add(Problem.error((String)"File '%s' can not be read (do you have permission to access this file?)", (Object[])new Object[]{file}));
        }
    }

    protected Path getBookmarkedPath(T paramsObject) {
        return ((BookmarkParameters)paramsObject).getBookmarkedPath();
    }

    protected ResultOrProblems<Path> getBookmarkedPathOr(T paramsObject) {
        try {
            return ResultOrProblems.of((Object)this.getBookmarkedPath(paramsObject));
        }
        catch (Exception e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
    }

    protected CoordinateReferenceSystem attemptPrjParse(URI location) {
        return this.attemptPrjParse(location, new ArrayList<Problem>());
    }

    protected CoordinateReferenceSystem attemptPrjParse(URI location, List<Problem> problems) {
        File prj;
        if (!UriHelper.isFile(location)) {
            log.info("URI {} is not a file resource, prj parsing may fail", (Object)location);
            return null;
        }
        String pathPart = location.getPath();
        Path asPath = Paths.get(location);
        String extension = com.google.common.io.Files.getFileExtension((String)pathPart);
        if (!Strings.isNullOrEmpty((String)extension) && (prj = asPath.getParent().resolve(com.google.common.io.Files.getNameWithoutExtension((String)pathPart) + ".prj").toFile()).exists()) {
            CoordinateReferenceSystem parsed = this.attemptPrjParse(prj);
            if (parsed == null && !this.canGeoToolsParsePrj(prj)) {
                problems.add(((FileProblems)Problems.get(FileProblems.class)).unsupportedFormat(prj).withChildren(new Problems[]{new Problem(Problem.Severity.INFO, (ProblemCode)ProblemCodes.UNSUPPORTED_PRJ_TIP, new Object[0])}));
            }
            return parsed;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean canGeoToolsParsePrj(File prj) {
        try (FileChannel channel = new FileInputStream(prj).getChannel();){
            boolean bl;
            try (PrjFileReader projReader = new PrjFileReader((ReadableByteChannel)channel);){
                bl = true;
            }
            return bl;
        }
        catch (IOException | FactoryException throwable) {
            return false;
        }
    }

    private CoordinateReferenceSystem attemptPrjParse(File prj) {
        List parsers = this.engine.getFeaturesOfType(PrjParser.class);
        if (parsers.size() == 0) {
            log.info("No prj parsers present, GeoTools parser will be used");
        }
        String prjContents = null;
        for (PrjParser parser : parsers) {
            if (prjContents == null) {
                try {
                    List<String> lines = Files.readAllLines(prj.toPath(), Charset.forName("LATIN1"));
                    StringBuilder builder = new StringBuilder();
                    lines.forEach(str -> builder.append((String)str).append("\n"));
                    prjContents = builder.toString();
                }
                catch (IOException e) {
                    throw new RuntimeException("uh oh, latin1 is missing", e);
                }
            }
            try {
                return parser.parsePrj(prjContents);
            }
            catch (Throwable e) {
                log.warn("Failed to parse prj using {}", (Object)parser, (Object)e);
            }
        }
        return null;
    }

    static Path resourceToPath(Resource resource, BindingContext bindingContext) throws RiskscapeIOException {
        try {
            String targetFilename = BaseBookmarkResolver.localFilename(resource.getLocation());
            Resource.Options options = new Resource.Options();
            options.tempDirectory = Optional.of(bindingContext.getTempDirectory());
            Path localPath = (Path)resource.ensureLocal(options).orElseThrow(probs -> new RiskscapeIOException(Problems.toSingleProblem((List)probs)));
            if (localPath.toString().endsWith(".zip")) {
                Path tempDirectory = Files.createTempDirectory(bindingContext.getTempDirectory(), "rs-resource", new FileAttribute[0]);
                try (ZipFile zip = new ZipFile(localPath.toFile());){
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry ze = entries.nextElement();
                        InputStream is = zip.getInputStream(ze);
                        try {
                            Files.copy(is, tempDirectory.resolve(ze.getName()), new CopyOption[0]);
                        }
                        finally {
                            if (is == null) continue;
                            is.close();
                        }
                    }
                    Path targetInZip = tempDirectory.resolve(targetFilename.substring(0, targetFilename.length() - ".zip".length()));
                    if (targetInZip.toFile().exists()) {
                        localPath = targetInZip;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return localPath;
        }
        catch (IOException e) {
            throw new RiskscapeIOException("Could not access " + resource.getLocation().toString(), (Exception)e);
        }
    }

    static String localFilename(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        String path = uri.getPath();
        if (path != null && !path.endsWith("/")) {
            int lastSlash = path.lastIndexOf("/");
            if (lastSlash > -1) {
                return path.substring(lastSlash + 1);
            }
            return path;
        }
        return "resource";
    }

    @Generated
    public JavaParameterSet<T> getParameterSet() {
        return this.parameterSet;
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    public static enum ProblemCodes implements ProblemCode
    {
        USER_DEFINED_CRS_ERROR,
        UNSUPPORTED_PRJ_TIP;

    }
}

