/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.i18n.MessageKey;
import nz.org.riskscape.engine.i18n.MessageSource;
import nz.org.riskscape.engine.i18n.RiskscapeMessageUtils;
import nz.org.riskscape.picocli.CommandLine;

public class Table {
    public static CommandLine.Help.Ansi defaultAnsi = CommandLine.Help.Ansi.AUTO;
    public static final String LINE_BREAK = OsUtils.LINE_SEPARATOR + " " + OsUtils.LINE_SEPARATOR;
    public static final String LINE_ENDINGS_REGEX = "\r\n|\r|\n";
    private static final int LINES_CAPACITY = 10;
    private final List<List<CommandLine.Help.Ansi.Text>> rows;
    private final List<CommandLine.Help.Ansi.Text> header;

    public static List<List<CommandLine.Help.Ansi.Text>> rowsToText(List<List<String>> rows, CommandLine.Help.Ansi.IStyle ... styles) {
        return Lists.transform(rows, row -> Table.rowToText(row, styles));
    }

    private static CommandLine.Help.Ansi.Text applyAnsi(Object applyTo, CommandLine.Help.Ansi ansi, CommandLine.Help.Ansi.IStyle ... styles) {
        return ansi.apply(applyTo == null ? "" : applyTo.toString(), Arrays.asList(styles));
    }

    public static List<CommandLine.Help.Ansi.Text> rowToText(List<String> things, CommandLine.Help.Ansi.IStyle ... styles) {
        return Lists.transform(things, str -> Table.applyAnsi(str, defaultAnsi, styles));
    }

    private static <T> List<List<CommandLine.Help.Ansi.Text>> getRows(List<T> items, List<Property<T>> properties) {
        return Lists.transform(items, item -> Lists.transform((List)properties, property -> property.callback.apply(item)));
    }

    public static <T, U> List<CommandLine.Help.Ansi.Text> getHeaders(MessageSource ms, Class<T> itemClass, List<Property<U>> props) {
        return Lists.transform(props, p -> {
            String str = ms.getMessage((MessageKey)RiskscapeMessageUtils.forFieldLabel(p.field, itemClass));
            return Table.applyAnsi(str, defaultAnsi, new CommandLine.Help.Ansi.IStyle[0]);
        });
    }

    public static <T> Table fromList(List<T> items, Class<?> itemClass, MessageSource messages, List<Property<T>> props) {
        return new Table(Table.getHeaders(messages, itemClass, props), Table.getRows(items, props));
    }

    public static <T> Table fromList(List<T> items, String ... propertyNames) {
        List<String> propertyNameList = Arrays.asList(propertyNames);
        List props = Lists.transform(propertyNameList, name -> Property.of(name));
        return new Table(Table.rowToText(propertyNameList, new CommandLine.Help.Ansi.IStyle[0]), Table.getRows(items, props));
    }

    public static Table fromStrings(List<List<String>> strings) {
        return new Table(Table.rowToText(strings.get(0), new CommandLine.Help.Ansi.IStyle[0]), Table.rowsToText(strings.subList(1, strings.size()), new CommandLine.Help.Ansi.IStyle[0]));
    }

    public Table(List<CommandLine.Help.Ansi.Text> header, List<List<CommandLine.Help.Ansi.Text>> rows) {
        this.header = header;
        this.rows = rows.stream().sorted((row1, row2) -> ((CommandLine.Help.Ansi.Text)row1.get(0)).plainString().compareTo(((CommandLine.Help.Ansi.Text)row2.get(0)).plainString())).collect(Collectors.toList());
    }

    private List<Integer> computeColumnWidths(int termWidth) {
        List widths = this.header.stream().map(CommandLine.Help.Ansi.Text::getCJKAdjustedLength).collect(Collectors.toList());
        ArrayList maxWidths = Lists.newArrayList(widths);
        this.rows.forEach(row -> {
            for (int i = 0; i < widths.size(); ++i) {
                CommandLine.Help.Ansi.Text content = (CommandLine.Help.Ansi.Text)row.get(i);
                if (content == null) continue;
                String plainText = content.plainString();
                for (String part : plainText.split(LINE_ENDINGS_REGEX)) {
                    maxWidths.set(i, Math.max((Integer)maxWidths.get(i), part.length()));
                }
            }
        });
        int fairWidth = termWidth / widths.size();
        if (maxWidths.stream().collect(Collectors.summingInt(integer -> integer)) > termWidth) {
            int numFlexColumns = 0;
            int availableFlexSpace = 0;
            for (int i = 0; i < maxWidths.size(); ++i) {
                if ((Integer)maxWidths.get(i) > fairWidth) {
                    ++numFlexColumns;
                    availableFlexSpace += fairWidth;
                    maxWidths.set(i, -1);
                    continue;
                }
                availableFlexSpace += fairWidth - (Integer)maxWidths.get(i);
            }
            int flexColumnWidth = availableFlexSpace / numFlexColumns;
            for (int i = 0; i < maxWidths.size(); ++i) {
                if ((Integer)maxWidths.get(i) != -1) continue;
                maxWidths.set(i, flexColumnWidth);
            }
            for (int currentTotalWidth = maxWidths.stream().collect(Collectors.summingInt(integer -> integer)).intValue(); currentTotalWidth < termWidth; ++currentTotalWidth) {
                int idx = currentTotalWidth % maxWidths.size();
                maxWidths.set(idx, (Integer)maxWidths.get(idx) + 1);
            }
        }
        return maxWidths;
    }

    public void print(Terminal terminal) {
        int displayWidth = terminal.getDisplayWidth();
        int displayHeight = terminal.getDisplayHeight();
        PrintStream stream = terminal.getOut();
        int usableWidth = displayWidth - 1 - this.header.size();
        int usableHeight = displayHeight - 2;
        List<Integer> columnWidths = this.computeColumnWidths(usableWidth);
        String hline = columnWidths.stream().map(width -> Strings.repeat((String)"-", (int)width)).collect(Collectors.joining("+", "+", "+"));
        String rowSep = columnWidths.stream().map(width -> Strings.repeat((String)" ", (int)width)).collect(Collectors.joining("|", "|", "|"));
        stream.println(hline);
        List<List<String>> griddedRow = this.gridifyRow(columnWidths, this.header);
        for (List<String> gridRow : griddedRow) {
            stream.print('|');
            for (String string : gridRow) {
                stream.print(string);
                stream.print('|');
            }
            stream.println();
            --usableHeight;
        }
        stream.println(hline);
        for (int i = 0; i < this.rows.size(); ++i) {
            if (i != 0) {
                stream.println(rowSep);
                --usableHeight;
            }
            List<CommandLine.Help.Ansi.Text> row = this.rows.get(i);
            griddedRow = this.gridifyRow(columnWidths, row);
            for (List list : griddedRow) {
                stream.print('|');
                for (String cellText : list) {
                    stream.print(cellText);
                    stream.print('|');
                }
                stream.println();
                if (--usableHeight > 1 || !terminal.isTTY()) continue;
                this.waitForUser(terminal);
                usableHeight = displayHeight;
            }
        }
        stream.println(hline);
    }

    private List<List<String>> gridifyRow(List<Integer> columnWidths, List<CommandLine.Help.Ansi.Text> row) {
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i < row.size(); ++i) {
            CommandLine.Help.Ansi.Text cellText = row.get(i);
            if (cellText == null) {
                cellText = Terminal.EMPTY_TEXT;
            }
            int width = columnWidths.get(i);
            List<CommandLine.Help.Ansi.Text> splitText = Table.splitText(width, cellText);
            columns.add(splitText);
        }
        int numRows = columns.stream().map(l -> l.size()).collect(Collectors.maxBy(Integer::compareTo)).orElse(0);
        ArrayList gridded = Lists.newArrayList();
        for (int i = 0; i < numRows; ++i) {
            ArrayList gridRow = Lists.newArrayListWithCapacity((int)row.size());
            gridded.add(gridRow);
            for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
                List column = (List)columns.get(columnIndex);
                if (column.size() > i) {
                    CommandLine.Help.Ansi.Text cellText = (CommandLine.Help.Ansi.Text)column.get(i);
                    gridRow.add(cellText.toString() + Strings.repeat((String)" ", (int)(columnWidths.get(columnIndex) - cellText.getCJKAdjustedLength())));
                    continue;
                }
                gridRow.add(Strings.padEnd((String)"", (int)columnWidths.get(columnIndex), (char)' '));
            }
        }
        return gridded;
    }

    public static List<CommandLine.Help.Ansi.Text> splitText(int maxWidth, CommandLine.Help.Ansi.Text cellText) {
        BreakIterator tokenizer = BreakIterator.getLineInstance();
        ArrayList lines = Lists.newArrayListWithCapacity((int)10);
        String plainString = cellText.plainString();
        boolean newline = true;
        int paraPos = 0;
        for (String paraString : plainString.split(LINE_ENDINGS_REGEX)) {
            paraPos = plainString.indexOf(paraString, paraPos);
            CommandLine.Help.Ansi.Text paraText = cellText.substring(paraPos, paraString.length());
            paraPos += paraString.length();
            CommandLine.Help.Ansi.Text ansiBuffer = defaultAnsi.apply("", Terminal.NO_STYLES);
            int currentLength = 0;
            tokenizer.setText(paraString);
            int start = tokenizer.first();
            int end = tokenizer.next();
            while (end != -1) {
                CommandLine.Help.Ansi.Text textPiece = paraText.substring(start, end);
                String plainPiece = textPiece.plainString();
                String plainPieceTrimmed = plainPiece.trim();
                CommandLine.Help.Ansi.Text trimmed = textPiece.substring(0, plainPieceTrimmed.length());
                if (!newline || !Strings.isNullOrEmpty((String)plainPiece.trim())) {
                    if (currentLength + textPiece.getCJKAdjustedLength() <= maxWidth) {
                        newline = false;
                        ansiBuffer = ansiBuffer.concat(textPiece);
                        currentLength += textPiece.getCJKAdjustedLength();
                    } else if (currentLength + trimmed.getCJKAdjustedLength() == maxWidth) {
                        newline = false;
                        ansiBuffer = ansiBuffer.concat(trimmed);
                        currentLength += trimmed.getCJKAdjustedLength();
                    } else {
                        if (newline) {
                            CommandLine.Help.Ansi.Text fragment = textPiece.substring(0, maxWidth - 1);
                            ansiBuffer = ansiBuffer.concat(fragment).concat(Character.toString('\u2026'));
                            currentLength += fragment.getCJKAdjustedLength();
                        } else {
                            end = tokenizer.previous();
                            start = tokenizer.previous();
                        }
                        newline = true;
                        lines.add(ansiBuffer);
                        ansiBuffer = Terminal.EMPTY_TEXT;
                        currentLength = 0;
                    }
                }
                start = end;
                end = tokenizer.next();
            }
            if (ansiBuffer.plainString().length() == 0) continue;
            lines.add(ansiBuffer);
        }
        return lines;
    }

    private void waitForUser(Terminal terminal) {
        terminal.getOut().format("Press enter to continue...", new Object[0]).flush();
        try {
            terminal.readline();
        }
        catch (IOException e) {
            terminal.getOut().println(e);
        }
    }

    @Generated
    public List<List<CommandLine.Help.Ansi.Text>> getRows() {
        return this.rows;
    }

    @Generated
    public List<CommandLine.Help.Ansi.Text> getHeader() {
        return this.header;
    }

    public static final class Property<T> {
        public final String field;
        public final Function<T, CommandLine.Help.Ansi.Text> callback;

        public static <T> Property<T> of(String field, Function<T, String> callback) {
            return new Property<T>(field, callback.andThen(str -> Table.applyAnsi(str, defaultAnsi, new CommandLine.Help.Ansi.IStyle[0])));
        }

        public static <T> Property<T> styled(String field, BiFunction<T, CommandLine.Help.Ansi, CommandLine.Help.Ansi.Text> callback) {
            return new Property<Object>(field, t -> (CommandLine.Help.Ansi.Text)callback.apply(t, defaultAnsi));
        }

        public static <T> Property<T> of(String fieldName) {
            String methodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            AtomicReference accessor = new AtomicReference();
            return new Property<Object>(fieldName, item -> {
                Object result;
                Method method = (Method)accessor.get();
                if (method == null || method.getClass() != item.getClass()) {
                    try {
                        method = item.getClass().getMethod(methodName, new Class[0]);
                        accessor.set(method);
                    }
                    catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
                        throw new RuntimeException("Failed to lookup method for field " + fieldName, e);
                    }
                }
                try {
                    result = method.invoke(item, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException("Failed to call method for field " + fieldName, e);
                }
                return Table.applyAnsi(result, defaultAnsi, new CommandLine.Help.Ansi.IStyle[0]);
            });
        }

        @Generated
        public Property(String field, Function<T, CommandLine.Help.Ansi.Text> callback) {
            this.field = field;
            this.callback = callback;
        }
    }
}

