/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public interface PipelineRenderer {
    default public void printPipeline(RealizedPipeline realized, Formatter out, TerminalCommand command) {
        this.printPipeline(realized, out, command.getMessages(), command.getTerminal().getLocale());
    }

    default public void printPipeline(RealizedPipeline realized, Formatter out, Messages messages, Locale locale) {
        for (RealizedStep step : realized.getRealizedSteps()) {
            out.format("Step: %s:[%s]%n", step.getName(), step.getImplementation());
            if (!step.getDependencies().isEmpty()) {
                out.format("  Inputs: %s%n", step.getDependencies().stream().map(RealizedStep::getName).collect(Collectors.toList()));
            }
            out.format("  Parameters: %n", new Object[0]);
            ArrayList parameterNames = Lists.newArrayList(step.getBoundParameters().keySet());
            Collections.sort(parameterNames);
            for (Object parameterName : parameterNames) {
                List boundValues = (List)step.getBoundParameters().get(parameterName);
                if (boundValues.size() == 1) {
                    out.format("    %s : %s%n", parameterName, this.boundPipelineParameterToString(boundValues.get(0)));
                    continue;
                }
                if (boundValues.size() > 1) {
                    out.format("    %s : [%n", parameterName);
                    int idx = 0;
                    for (Object object : boundValues) {
                        out.format("        %d : %s%n", idx + 1, this.boundPipelineParameterToString(object));
                    }
                    out.format("    ]%n", new Object[0]);
                    continue;
                }
                out.format("    %s : <none-given>%n", parameterName);
            }
            out.format("  Produces:%n", new Object[0]);
            this.printType(out, 6, step.getProduces());
            ResultOrProblems resultOr = step.getResult();
            if (resultOr.hasErrors()) {
                Object parameterName;
                out.format("  Result: failed%n", new Object[0]);
                parameterName = resultOr.getProblems().iterator();
                while (parameterName.hasNext()) {
                    Problem problem = (Problem)parameterName.next();
                    out.format("%s%n", messages.renderProblem(problem).toString(opts -> {
                        opts.prefixAll = "    ";
                    }));
                }
                continue;
            }
            Object result = resultOr.get();
            out.format("  Result: %s%n", result.getClass().getSimpleName());
        }
    }

    default public String boundPipelineParameterToString(Object object) {
        if (object instanceof Expression) {
            return ((Expression)object).toSource();
        }
        return object.toString();
    }

    default public void printType(Formatter stdout, int i, Struct type) {
        String spaces = Strings.repeat((String)" ", (int)i);
        for (Struct.StructMember member : type.getMembers()) {
            stdout.format("%s%s =>", spaces, member.getKey());
            if (member.getType().getUnwrappedType() instanceof Struct) {
                stdout.format("%n", new Object[0]);
                this.printType(stdout, i + 2, (Struct)member.getType().getUnwrappedType());
                continue;
            }
            stdout.format(" %s%n", member.getType());
        }
    }

    default public void graph(RealizedPipeline pipeline, PrintStream dotOut, String graphType, String name, List<String> other) {
        dotOut.format("%s \"%s\" {%n", graphType, name);
        for (String otherString : other) {
            dotOut.println(otherString + ";");
        }
        for (RealizedStep step : pipeline.getRealizedSteps()) {
            dotOut.format("\"%s\"[label=\"%s\"];%n", step.getName(), step.getName());
        }
        for (RealizedStep step : pipeline.getRealizedSteps()) {
            for (RealizedStep dependency : step.getDependencies()) {
                String from = dependency.getName();
                String to = step.getName();
                String extra = "";
                dotOut.format("\"%s\" -> \"%s\"[%s];%n", from, to, extra);
            }
        }
        dotOut.println("}");
    }
}

