/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.cli;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.cli.Terminal;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.IdentifiedException;
import nz.org.riskscape.engine.OsUtils;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Reference;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.cli.ChildCommand;
import nz.org.riskscape.engine.cli.EngineCommand;
import nz.org.riskscape.engine.cli.ExitException;
import nz.org.riskscape.engine.cli.Table;
import nz.org.riskscape.engine.cli.TerminalCommand;
import nz.org.riskscape.engine.i18n.Messages;
import nz.org.riskscape.engine.resource.FileResource;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.resource.StreamResource;
import nz.org.riskscape.engine.resource.StringResource;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.picocli.CommandLine;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.rl.ast.Expression;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class ApplicationCommand
implements ChildCommand,
TerminalCommand,
EngineCommand {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true)
    private boolean help;
    private Terminal terminal;
    private Messages messages;
    private Engine engine;
    private Project project;

    public static <T extends Identified> T getObject(IdentifiedCollection<T> collection, String id, ProblemSink sink) throws ExitException {
        try {
            return (T)collection.get(id, sink);
        }
        catch (IdentifiedException e) {
            throw new ExitException((Problems)e.getProblem(), (Throwable)e);
        }
    }

    public static String paramString(BoundParameters map) {
        List<Pair<String, String>> paramValues = map.getBoundTo().getDeclared().stream().map(Parameter::getName).map(key -> Pair.of((Object)key, ApplicationCommand.pickValuesForDisplay(key, map))).filter(pair -> ((List)pair.getRight()).size() > 0).map(pair -> Pair.of((Object)((String)pair.getLeft()).toString(), (Object)((List)pair.getRight()).toString())).collect(Collectors.toList());
        paramValues.sort((l, r) -> ((String)l.getLeft()).compareTo((String)r.getLeft()));
        return ApplicationCommand.combineKeyValuesForDisplay(paramValues);
    }

    public static String combineKeyValuesForDisplay(List<Pair<String, String>> paramValues) {
        int maxWidth = 0;
        for (Pair<String, String> pair2 : paramValues) {
            maxWidth = Math.max(maxWidth, ((String)pair2.getLeft()).length());
        }
        int finalWidth = maxWidth;
        return paramValues.stream().map(pair -> Strings.padEnd((String)((String)pair.getLeft()), (int)finalWidth, (char)' ') + " = " + (String)pair.getRight()).collect(Collectors.joining(OsUtils.LINE_SEPARATOR));
    }

    private static List<?> pickValuesForDisplay(String key, BoundParameters params) {
        List boundValues = params.getValues(key);
        List unboundValues = (List)params.getUnbound().get(key);
        if (boundValues == null || boundValues.isEmpty()) {
            Parameter param = params.getBoundTo().get(key);
            if (!param.isOptional()) {
                return Lists.newArrayList((Object[])new String[]{""});
            }
            return Collections.emptyList();
        }
        List picked = unboundValues == null || unboundValues.isEmpty() ? boundValues : unboundValues;
        return ApplicationCommand.stringifyExpressions(picked);
    }

    private static <T> List<Object> stringifyExpressions(List<T> pair) {
        return pair.stream().map(val -> val instanceof Expression ? ((Expression)val).toSource() : val).collect(Collectors.toList());
    }

    public Object run() {
        return this.doCommand(this.project);
    }

    protected Resource resourceFrom(String filepathOrContent) {
        try {
            File file = new File(filepathOrContent.trim());
            if (file.getName().equals("-")) {
                return new StreamResource(file.toURI(), this.getTerminal().getIn()){

                    public String toString() {
                        return "<STDIN>";
                    }
                };
            }
            if (file.exists()) {
                return FileResource.load(file.toURI());
            }
            return new StringResource(file.toURI(), filepathOrContent);
        }
        catch (ResourceLoadingException e) {
            throw new ExitException(1, (Throwable)e, "Could not read argument, reason: %s%n%nMake sure parameter is either:%n  * A path to a file, or%n  * '-' to read from STDIN, or%n  * A valid string%n", new Object[]{e});
        }
    }

    protected Object parseJsonArguments(String parametersJsonOption) {
        return this.parseJsonArguments(this.resourceFrom(parametersJsonOption));
    }

    protected Object parseJsonArguments(Resource input) {
        JSONParser parser = new JSONParser();
        try {
            return parser.parse(input.getContentAsString());
        }
        catch (ParseException e) {
            throw new ExitException(1, (Throwable)e, "Could not parse json argument, reason: %s%n%nMake sure parameter is either:%n  * A path to a file containing a valid JSON string, or%n  * '-' to read JSON from STDIN, or%n  * A valid JSON string%n", new Object[]{e});
        }
    }

    public abstract Object doCommand(Project var1);

    protected Optional<String> getDetailedHelp(Object object, String ... parts) {
        List detailedHelp = this.getMessages().getDetailedHelpMessage(object, parts);
        if (detailedHelp.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.format(String.join((CharSequence)"%n %n", detailedHelp), new Object[0]));
    }

    protected <T> CommandLine.Help.Ansi.Text formatProblemsForTableText(CommandLine.Help.Ansi ansi, Reference<T> reference) {
        List<CommandLine.Help.Ansi.IStyle> styles = reference.getResult().hasErrors() ? Arrays.asList(CommandLine.Help.Ansi.Style.bg_red, CommandLine.Help.Ansi.Style.fg_white) : Arrays.asList(CommandLine.Help.Ansi.Style.bg_yellow, CommandLine.Help.Ansi.Style.fg_white);
        return ansi.apply(this.formatFailedObjectErrorsForTable(reference), styles);
    }

    protected String formatFailedObjectErrorsForTable(Reference<?> reference) {
        StringBuilder failures = new StringBuilder();
        for (Problem problem : reference.getResult().getProblems()) {
            failures.append(this.messages.renderProblem(problem).toString(o -> {
                o.terminateWith = OsUtils.LINE_SEPARATOR;
            }));
        }
        return failures.toString();
    }

    public <T extends Identified> CommandLine.Help.Ansi.Text displayWithProblems(CommandLine.Help.Ansi ansi, Reference<T> ref, Function<T, String> displayFunction) {
        if (ref.getResult().hasProblems()) {
            CommandLine.Help.Ansi.Text failures = this.formatProblemsForTableText(ansi, ref);
            String description = (String)ref.getResult().map(i -> (String)displayFunction.apply((Identified)i)).orElse((Object)"");
            if (description.length() == 0) {
                return failures;
            }
            return ansi.apply(description, Terminal.NO_STYLES).concat(Table.LINE_BREAK).concat(failures);
        }
        return ansi.apply(displayFunction.apply((Identified)ref.getResult().get()), Terminal.NO_STYLES);
    }

    public <T extends Identified> Table.Property<Reference<T>> asPropertyWithProblems(String colName, Function<T, String> displayFunction) {
        return Table.Property.styled(colName, (ref, ansi) -> this.displayWithProblems((CommandLine.Help.Ansi)ansi, (Reference)ref, displayFunction));
    }

    protected URI bindOutput(String output) throws ExitException {
        BindingContext ctx = this.project.newBindingContext().withNewRelativeTo(Paths.get("", new String[0]).toUri());
        return (URI)ctx.bind((Object)output, URI.class).orElseThrow(problems -> new ExitException((Problems)Problems.foundWith((Object)"--output", (List)problems)));
    }

    @Generated
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Generated
    public void setTerminal(Terminal terminal) {
        this.terminal = terminal;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @Generated
    public Engine getEngine() {
        return this.engine;
    }

    @Generated
    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    @Generated
    public Project getProject() {
        return this.project;
    }

    @Generated
    public void setProject(Project project) {
        this.project = project;
    }
}

