/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Defaults;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.BoundJavaParameters;
import nz.org.riskscape.engine.bind.BoundParameters;
import nz.org.riskscape.engine.bind.IncludeParameters;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.util.ListUtils;

public class JavaParameterSet<T>
extends ParameterSet {
    private final Class<T> bindsTo;
    private final List<JavaParameter> javaParameters;

    public static <T> JavaParameterSet<T> fromBindingClass(Class<T> bindsTo) {
        return JavaParameterSet.fromBindingClass(bindsTo, CaseFormat.LOWER_HYPHEN);
    }

    public static <T> JavaParameterSet<T> fromBindingClass(Class<T> bindsTo, CaseFormat keyFormat) {
        List<JavaParameter> javaParams = JavaParameterSet.buildParameters(ReflectionUtils.newInstance(bindsTo), Collections.emptyList(), keyFormat);
        return new JavaParameterSet<T>(javaParams, bindsTo);
    }

    public static <T> JavaParameterSet<T> fromBindingInstance(Class<T> bindsTo, T bindsToInstance) {
        List<JavaParameter> javaParams = JavaParameterSet.buildParameters(bindsToInstance, Collections.emptyList(), CaseFormat.LOWER_HYPHEN);
        return new JavaParameterSet<T>(javaParams, bindsTo);
    }

    static List<JavaParameter> buildParameters(Object instance, @NonNull List<Field> nesting, CaseFormat parameterNameFormat) {
        if (nesting == null) {
            throw new NullPointerException("nesting is marked non-null but is null");
        }
        Class<?> parameterClass = instance.getClass();
        List fields = ReflectionUtils.getAnnotatedFields(parameterClass, ParameterField.class);
        int finalSize = fields.size();
        List includedClasses = ReflectionUtils.getAnnotatedFields(parameterClass, IncludeParameters.class);
        ArrayList<List<JavaParameter>> subResults = new ArrayList<List<JavaParameter>>(includedClasses.size());
        for (Field included : includedClasses) {
            Object object;
            included.setAccessible(true);
            try {
                object = included.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Unable to access included parameter object - " + String.valueOf(included), e);
            }
            List<JavaParameter> subParams = JavaParameterSet.buildParameters(object, ListUtils.append(nesting, (Object)included), parameterNameFormat);
            finalSize += subParams.size();
            subResults.add(subParams);
        }
        ArrayList<JavaParameter> result = new ArrayList<JavaParameter>(finalSize);
        for (Field field : fields) {
            result.add(new JavaParameter(JavaParameterSet.modelParameterFromField(field, instance, parameterNameFormat), field, instance, nesting));
        }
        for (List list : subResults) {
            result.addAll(list);
        }
        return result;
    }

    private static boolean isCollection(Field field) {
        ParameterField annotation = field.getAnnotation(ParameterField.class);
        return Collection.class.isAssignableFrom(field.getType()) && !annotation.scalarOverride();
    }

    static Parameter modelParameterFromField(@NonNull Field field, @NonNull Object empty, @NonNull CaseFormat caseFormat) {
        int min;
        Class parameterType;
        Object assignedDefault;
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (empty == null) {
            throw new NullPointerException("empty is marked non-null but is null");
        }
        if (caseFormat == null) {
            throw new NullPointerException("caseFormat is marked non-null but is null");
        }
        try {
            field.setAccessible(true);
            assignedDefault = empty == null ? null : field.get(empty);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to extract a possible default value from empty parameter class instance", e);
        }
        ParameterField annotation = field.getAnnotation(ParameterField.class);
        int max = 1;
        boolean isCollection = JavaParameterSet.isCollection(field);
        if (!(isCollection || annotation.maxRequired() == -1 && annotation.minRequired() == -1)) {
            throw new IllegalArgumentException("Non-collection fields can not specify min and max - " + String.valueOf(field));
        }
        BiFunction<BindingContext, Parameter, List> function = null;
        if (!annotation.defaultValue().equals("No default supplied")) {
            function = (mc, mp) -> Collections.singletonList(mc.bind(mp, annotation.defaultValue()));
        } else if (assignedDefault != null) {
            if (assignedDefault instanceof Optional) {
                Optional assignedOptional = (Optional)assignedDefault;
                if (assignedOptional.isPresent()) {
                    function = (mp, mc) -> Collections.singletonList(assignedOptional.get());
                }
            } else if (isCollection && assignedDefault != null) {
                Collection assignedCollection = (Collection)assignedDefault;
                function = (mp, mc) -> Lists.newArrayList((Iterable)assignedCollection);
            } else {
                function = (mp, mc) -> Collections.singletonList(assignedDefault);
            }
        }
        if (isCollection || Optional.class.isAssignableFrom(field.getType())) {
            try {
                ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                parameterType = (Class)genericType.getActualTypeArguments()[0];
            }
            catch (ClassCastException ex) {
                throw new RuntimeException(String.format("API misuse - optional field %s needs to be parameterized with a single class", field));
            }
            min = 0;
            if (isCollection) {
                max = annotation.maxRequired() != -1 ? annotation.maxRequired() : Integer.MAX_VALUE;
                min = annotation.minRequired() != -1 ? annotation.minRequired() : 0;
            }
        } else {
            parameterType = Primitives.wrap(field.getType());
            min = 1;
        }
        Converter converter = CaseFormat.LOWER_CAMEL.converterTo(caseFormat);
        return new Parameter((String)converter.convert((Object)field.getName()), parameterType, Optional.ofNullable(function), min, max);
    }

    protected JavaParameterSet(List<JavaParameter> javaParams, Class<T> bindsTo) {
        super((Collection)javaParams.stream().map(JavaParameter::getParameter).collect(Collectors.toList()));
        this.bindsTo = bindsTo;
        this.javaParameters = javaParams;
    }

    public ResultOrProblems<BoundJavaParameters<T>> bindToObject(BindingContext context, Map<String, List<?>> unbound) {
        return super.bind(context, unbound).map(bp -> new BoundJavaParameters<T>((BoundParameters)bp, this.newInstance((BoundParameters)bp)));
    }

    public BoundJavaParameters<T> bindToObject(BoundParameters parameters) {
        if (!parameters.getBoundTo().getDeclared().equals(this.getDeclared())) {
            throw new IllegalArgumentException("given parameters are from a different parameter set");
        }
        return new BoundJavaParameters<T>(parameters, this.newInstance(parameters));
    }

    protected T newInstance(BoundParameters p) {
        Object instance = ReflectionUtils.newInstance(this.bindsTo);
        this.bindMapToObject(p.getValueMap(), instance);
        return (T)instance;
    }

    private void bindMapToObject(Map<String, List<?>> values, T instance) {
        for (JavaParameter javaParameter : this.javaParameters) {
            List<?> entry = values.get(javaParameter.getParameter().getName());
            Field field = javaParameter.field;
            field.setAccessible(true);
            try {
                Object toSet;
                Object thisBindTo = instance;
                for (Field nesting : javaParameter.nesting) {
                    thisBindTo = nesting.get(thisBindTo);
                    if (thisBindTo != null) continue;
                    throw new NullPointerException("Field " + String.valueOf(nesting) + " was null for next parameter instance");
                }
                if (entry == null) {
                    this.bindMissingValueForField(field, thisBindTo);
                    continue;
                }
                if (JavaParameterSet.isCollection(field)) {
                    Collection<Object> toSetCollection = this.matchCollectionType(field.getType(), values);
                    toSetCollection.addAll(entry);
                    toSet = toSetCollection;
                } else {
                    toSet = entry.size() > 0 ? (Object)entry.get(entry.size() - 1) : null;
                }
                if (Optional.class.isAssignableFrom(field.getType())) {
                    toSet = Optional.ofNullable(toSet);
                } else if (field.getType().isPrimitive() && toSet == null) {
                    toSet = Defaults.defaultValue(field.getType());
                }
                field.set(thisBindTo, toSet);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(String.format("Unable to set value %s to field %s", entry, field), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void bindMissingValueForField(Field field, Object bindTo) {
        HashSet toSet;
        if (field.getType().equals(Optional.class)) {
            toSet = Optional.empty();
        } else {
            Collection setCollection;
            if (!JavaParameterSet.isCollection(field)) return;
            try {
                setCollection = (Collection)field.get(bindTo);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(String.format("Unable to sniff collection field default for %s", field), e);
            }
            if (setCollection == null) {
                if (List.class.isAssignableFrom(field.getType())) {
                    toSet = new ArrayList(0);
                } else {
                    if (!Set.class.isAssignableFrom(field.getType())) throw new NullPointerException(String.format("Un-bound parameter class instance has unrecognised collection type '%s' and no empty default has been set.", field.getType()));
                    toSet = new HashSet(0);
                }
            } else {
                if (setCollection.isEmpty()) return;
                throw new RiskscapeException("Un-bound parameter class instance has a non-empty collection set where no parameter has been supplied.  This is a misuse of the binding API. Default values should be supplied to  any parameter map accepting method.");
            }
        }
        try {
            field.set(bindTo, toSet);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(String.format("Unable to set value empty optional to field %s", field), e);
        }
    }

    private Collection<Object> matchCollectionType(Class<?> type, Map<String, List<?>> values) {
        if (type.equals(List.class)) {
            return new ArrayList<Object>();
        }
        if (type.equals(Set.class)) {
            return new HashSet<Object>();
        }
        if (type.equals(Collection.class)) {
            return new ArrayList<Object>();
        }
        throw new RuntimeException("unknown collection type:" + String.valueOf(type));
    }

    @Generated
    public Class<T> getBindsTo() {
        return this.bindsTo;
    }

    @Generated
    public List<JavaParameter> getJavaParameters() {
        return this.javaParameters;
    }

    static class JavaParameter {
        public final Parameter parameter;
        public final Field field;
        public final Object instance;
        public final List<Field> nesting;

        @Generated
        public JavaParameter(Parameter parameter, Field field, Object instance, List<Field> nesting) {
            this.parameter = parameter;
            this.field = field;
            this.instance = instance;
            this.nesting = nesting;
        }

        @Generated
        public Parameter getParameter() {
            return this.parameter;
        }
    }
}

