/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.bind;

import com.google.common.base.CaseFormat;
import java.util.LinkedList;
import lombok.Generated;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.Identified;
import nz.org.riskscape.engine.IdentifiedCollection;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.bind.ParameterBinder;
import nz.org.riskscape.engine.bind.ParameterBindingException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public abstract class BaseBinder
implements ParameterBinder {
    public String getId() {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getClass().getSimpleName());
    }

    public Object bind(BindingContext context, Parameter modelParameter, String value) throws ParameterBindingException {
        return this.bindValue(context, value, modelParameter.getType()).orElseThrow(ps -> new ParameterBindingException(modelParameter, ps));
    }

    protected <T extends Identified> ResultOrProblems<T> wrapLookupNullOnMissing(BindingContext context, Class<T> identifiedClass, String id) {
        return this.wrapLookupInternal(context, identifiedClass, id, true);
    }

    protected <T extends Identified> ResultOrProblems<T> wrapLookup(BindingContext context, Class<T> identifiedClass, String id) {
        return this.wrapLookupInternal(context, identifiedClass, id, false);
    }

    private <T extends Identified> ResultOrProblems<T> wrapLookupInternal(BindingContext context, Class<T> identifiedClass, String id, boolean nullOnMissing) {
        IdentifiedCollection collection = context.getProject().getCollectionByClass(identifiedClass);
        try {
            LinkedList problems = new LinkedList();
            Identified found = collection.get(id, p -> problems.add(p));
            return ResultOrProblems.of((Object)found, problems);
        }
        catch (FailedObjectException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)ex)});
        }
        catch (NoSuchObjectException ex) {
            if (nullOnMissing) {
                return null;
            }
            return ResultOrProblems.failed((Problem[])new Problem[]{ex.getProblem()});
        }
    }

    @Generated
    public BaseBinder() {
    }
}

