/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.auth;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.config.ConfigString;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.auth.Secret;
import nz.org.riskscape.engine.auth.Secrets;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problems;

public abstract class HttpSecret
implements Secret {
    private final String framework;
    @ParameterField
    private ConfigString id;
    @ParameterField
    private String hostname;
    @ParameterField
    private boolean allowHttp = false;
    @ParameterField
    private boolean allowSubdomains = false;

    public static Request getRequest(URI target, Engine engine) {
        if (engine.hasCollectionOf(Secret.class)) {
            return HttpSecret.getRequest(target, (Secrets)engine.getCollectionByClass(Secret.class));
        }
        return Request.noSecret(target);
    }

    public static Request getRequest(URI target, Secrets secrets) {
        HttpSecret toApply = secrets.getOfType(HttpSecret.class).stream().filter(s -> s.matches(target)).findFirst().orElse(null);
        if (toApply != null) {
            return Request.withSecret(target, toApply);
        }
        return Request.noSecret(target);
    }

    public URI getDefinedIn() {
        return this.id.getLocation();
    }

    public String getId() {
        return this.id.toString();
    }

    public void setId(String id) {
        this.id = ConfigString.anon((CharSequence)id);
    }

    public boolean matches(URI uri) {
        if (!uri.getScheme().startsWith("http")) {
            return false;
        }
        if (!this.allowHttp && uri.getScheme().equals("http")) {
            return false;
        }
        String host = this.getHostname();
        if (host.equals(uri.getHost())) {
            return true;
        }
        return this.allowSubdomains && uri.getHost().endsWith("." + host);
    }

    protected abstract void apply(Request var1);

    public String getHostname() {
        if (this.hostname.startsWith("http") && this.hostname.contains("://")) {
            try {
                URI h = new URI(this.hostname);
                return h.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return this.hostname;
    }

    @Generated
    public HttpSecret(String framework) {
        this.framework = framework;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpSecret)) {
            return false;
        }
        HttpSecret other = (HttpSecret)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAllowHttp() != other.isAllowHttp()) {
            return false;
        }
        if (this.isAllowSubdomains() != other.isAllowSubdomains()) {
            return false;
        }
        String this$framework = this.getFramework();
        String other$framework = other.getFramework();
        if (this$framework == null ? other$framework != null : !this$framework.equals(other$framework)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HttpSecret;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowHttp() ? 79 : 97);
        result = result * 59 + (this.isAllowSubdomains() ? 79 : 97);
        String $framework = this.getFramework();
        result = result * 59 + ($framework == null ? 43 : $framework.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    @Generated
    public String getFramework() {
        return this.framework;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public boolean isAllowHttp() {
        return this.allowHttp;
    }

    @Generated
    public void setAllowHttp(boolean allowHttp) {
        this.allowHttp = allowHttp;
    }

    @Generated
    public boolean isAllowSubdomains() {
        return this.allowSubdomains;
    }

    @Generated
    public void setAllowSubdomains(boolean allowSubdomains) {
        this.allowSubdomains = allowSubdomains;
    }

    public static class Request {
        private final String scheme;
        private final String hostname;
        private final int port;
        private final String query;
        private String path;
        private HttpSecret secret;
        private final List<Pair<String, String>> headers = new ArrayList<Pair<String, String>>();

        public static Request noSecret(URI uri) {
            Request request = new Request(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getQuery());
            request.setPath(uri.getPath());
            return request;
        }

        private static Request withSecret(URI uri, HttpSecret secret) {
            Request request = Request.noSecret(uri);
            request.secret = secret;
            secret.apply(request);
            return request;
        }

        public void addHeader(String name, String value) {
            this.headers.add((Pair<String, String>)Pair.of((Object)name, (Object)value));
        }

        public List<Pair<String, String>> getHeaders() {
            return List.copyOf(this.headers);
        }

        public URI getURI() {
            try {
                return new URI(this.scheme, null, this.hostname, this.port, this.path, this.query, null);
            }
            catch (URISyntaxException e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
        }

        public Optional<HttpSecret> getSecret() {
            return Optional.ofNullable(this.secret);
        }

        public boolean isSecretApplied() {
            return this.secret != null;
        }

        @Generated
        private Request(String scheme, String hostname, int port, String query) {
            this.scheme = scheme;
            this.hostname = hostname;
            this.port = port;
            this.query = query;
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }

        @Generated
        public String getHostname() {
            return this.hostname;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getQuery() {
            return this.query;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public void setPath(String path) {
            this.path = path;
        }
    }
}

