/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.postgis;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.data.Bookmark;
import nz.org.riskscape.engine.data.relation.FeatureSourceBookmarkResolver;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.postgis.PostGISConnectionOptions;
import nz.org.riskscape.postgis.PostGISPipelineOutputStore;
import nz.org.riskscape.postgis.PostGISProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostGISResolver
extends FeatureSourceBookmarkResolver<JDBCDataStore, Params> {
    public static final String FORMAT = "postgis";
    public static final PostgisNGDataStoreFactory FACTORY = new PostgisNGDataStoreFactory();
    private static final PostGISProblems POSTGIS_PROBLEMS = PostGISProblems.get();
    private final Map<String, String> aliasMapping = ImmutableMap.of((Object)"passwd", (Object)"password");

    public PostGISResolver(Engine engine) {
        super(engine);
    }

    protected JDBCDataStore createDataStore(Params params) throws MalformedURLException, IOException {
        try {
            return FACTORY.createDataStore(params.storeParams);
        }
        catch (Exception e) {
            throw new RiskscapeException((Problems)PostGISPipelineOutputStore.toConnectionFailure(params.connectionOptions.toLocation(), e));
        }
    }

    protected ResultOrProblems<SimpleFeatureSource> createFeatureSource(Params params, JDBCDataStore dataStore) {
        try {
            return super.createFeatureSource((RelationBookmarkParams)params, (DataStore)dataStore);
        }
        catch (Exception e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PostGISPipelineOutputStore.toConnectionFailure(params.connectionOptions.toLocation(), e)});
        }
    }

    protected void validateParameters(Params params, BindingContext context) {
        super.validateParameters((RelationBookmarkParams)params, context);
        params.populateConnectionOptions();
        params.connectionOptions.validate().ifElse(opt -> {
            Map<String, Object> storeParams = params.storeParams;
            storeParams.put(JDBCDataStoreFactory.DBTYPE.key, PostgisNGDataStoreFactory.DBTYPE.getDefaultValue());
            storeParams.put(JDBCDataStoreFactory.HOST.key, opt.getHost());
            storeParams.put(JDBCDataStoreFactory.PORT.key, opt.getPort());
            storeParams.put(JDBCDataStoreFactory.DATABASE.key, opt.getDatabase());
            storeParams.put(JDBCDataStoreFactory.USER.key, opt.getUser());
            if (!Strings.isNullOrEmpty((String)opt.getPassword())) {
                storeParams.put(JDBCDataStoreFactory.PASSWD.key, opt.getPassword());
            }
            List<DataAccessFactory.Param> factoryParams = Arrays.asList(FACTORY.getParametersInfo());
            for (DataAccessFactory.Param param : factoryParams) {
                Object storeParamValue = storeParams.get(param.key);
                String storeParam = storeParamValue == null ? null : storeParamValue.toString();
                if (!Strings.isNullOrEmpty((String)storeParam) || !param.isRequired().booleanValue()) continue;
                params.add(Problem.error((String)"'%s' is a required parameter for PostGIS bookmarks.  Parameters can also be set via the location, e.g. postgis://user:password@host:port/database", (Object[])new Object[]{param.key}));
            }
        }, problems -> params.problems.addAll(problems));
    }

    public String getFormat(Bookmark bookmark) {
        if (Strings.isNullOrEmpty((String)bookmark.getFormat()) && FORMAT.equals(bookmark.getLocation().getScheme())) {
            return FORMAT;
        }
        return bookmark.getFormat();
    }

    protected Map<String, String> getExtensionsToFormats() {
        return Collections.emptyMap();
    }

    public Set<String> getFormats() {
        return Collections.singleton(FORMAT);
    }

    @Generated
    public Map<String, String> getAliasMapping() {
        return this.aliasMapping;
    }

    public static class Params
    extends RelationBookmarkParams {
        @ParameterField
        public Optional<String> user = Optional.empty();
        @ParameterField
        public Optional<String> password = Optional.empty();
        @ParameterField
        public Optional<String> database = Optional.empty();
        @ParameterField
        public Optional<Integer> port = Optional.empty();
        public Map<String, Object> storeParams = Maps.newHashMap();
        public final PostGISConnectionOptions connectionOptions = new PostGISConnectionOptions();

        void populateConnectionOptions() {
            this.connectionOptions.setLocation(this.getLocation());
            this.connectionOptions.setEnvironment(System.getenv());
            this.user.ifPresent(u -> this.connectionOptions.setUser((String)u));
            this.password.ifPresent(p -> this.connectionOptions.setPassword((String)p));
            this.database.ifPresent(d -> this.connectionOptions.setDatabase((String)d));
            this.port.ifPresent(p -> this.connectionOptions.setPort((int)p));
        }
    }
}

