/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.postgis;

import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.sql.DataSource;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.OutputProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.defaults.data.jdbc.BaseJdbcOutputStore;
import nz.org.riskscape.engine.output.AxisSwapper;
import nz.org.riskscape.engine.output.BaseJdbcPipelineOutputContainer;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.output.PipelineOutputOptions;
import nz.org.riskscape.engine.output.PipelineOutputStore;
import nz.org.riskscape.engine.output.SinkParameters;
import nz.org.riskscape.engine.output.StructFlattener;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.sink.SaveSink;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.postgis.PostGISConnectionOptions;
import nz.org.riskscape.postgis.PostGISProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostGISPipelineOutputStore
implements PipelineOutputStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostGISPipelineOutputStore.class);
    private static final PostGISProblems POSTGIS_PROBLEMS = PostGISProblems.get();
    private final String id = "postgis";

    public static Problem toConnectionFailure(URI location, Exception cause) {
        return POSTGIS_PROBLEMS.connectionFailure(location, cause.getMessage()).withChildren(new Problems[]{POSTGIS_PROBLEMS.connectionTipSpelling(), POSTGIS_PROBLEMS.connectionTipPassword(), POSTGIS_PROBLEMS.connectionTipConnectivity()});
    }

    public int isApplicable(@NonNull URI outputLocation) {
        if (outputLocation == null) {
            throw new NullPointerException("outputLocation is marked non-null but is null");
        }
        return "postgis".equals(outputLocation.getScheme()) ? 1000 : 0;
    }

    public ResultOrProblems<PipelineOutputContainer> create(URI outputLocation, RealizedPipeline pipeline, PipelineOutputOptions options) {
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        Format userSpecifiedDefault = options.getFormat().orElse(null);
        if (userSpecifiedDefault != null) {
            if (!"postgis".equals(userSpecifiedDefault.getId())) {
                warnings.add(OutputProblems.get().userSpecifiedFormatIgnored(userSpecifiedDefault, (PipelineOutputStore)this));
            }
            options.setFormat(null);
        }
        if (options.isChecksum()) {
            warnings.add(OutputProblems.get().checksumNotSupported((PipelineOutputStore)this));
        }
        PostGISConnectionOptions cnxOptions = new PostGISConnectionOptions();
        cnxOptions.setLocation(outputLocation);
        cnxOptions.setEnvironment(System.getenv());
        return cnxOptions.validate().drainWarnings(warning -> warnings.add((Problem)warning)).composeProblems((severity, problems) -> POSTGIS_PROBLEMS.invalidLocation(outputLocation).withSeverity(severity).withChildren(problems)).flatMap(connectionOptions -> {
            PGSimpleDataSource ds = new PGSimpleDataSource();
            ds.setUrl(connectionOptions.toJdbcUri());
            try (Connection conn = ds.getConnection();){
                conn.getMetaData();
            }
            catch (SQLException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PostGISPipelineOutputStore.toConnectionFailure(outputLocation, e)});
            }
            return ResultOrProblems.of((Object)((Object)new PostGISOutputContainer(pipeline, outputLocation, options, (DataSource)ds)), (List)warnings);
        });
    }

    @Generated
    public String getId() {
        return this.id;
    }

    class PostGISOutputContainer
    extends BaseJdbcPipelineOutputContainer<PostGISJdbcAdaptor> {
        private URI postGisUri;

        PostGISOutputContainer(RealizedPipeline pipeline, URI postGisUri, PipelineOutputOptions options, DataSource ds) {
            super((PipelineOutputStore)PostGISPipelineOutputStore.this, (BaseJdbcOutputStore)new PostGISJdbcAdaptor(postGisUri, ds, options.isReplace()), pipeline, options);
            this.postGisUri = postGisUri;
        }

        public URI getStoredAt() {
            StringBuilder builder = new StringBuilder("postgis://");
            builder.append(this.postGisUri.getHost());
            if (this.postGisUri.getPort() > 0) {
                builder.append(":").append(this.postGisUri.getPort());
            }
            if (this.postGisUri.getRawPath() != null) {
                builder.append(this.postGisUri.getRawSchemeSpecificPart());
            }
            return URI.create(builder.toString());
        }

        protected ResultOrProblems<SaveSink> createSink(SinkParameters sinkParameters) {
            ArrayList<Problem> warnings = new ArrayList<Problem>();
            if (sinkParameters.getFormat().isPresent()) {
                warnings.add(OutputProblems.get().userSpecifiedFormatIgnored((Format)sinkParameters.getFormat().get(), this.getStore()));
            }
            return super.createSink(sinkParameters).withMoreProblems(warnings);
        }
    }

    class PostGISJdbcAdaptor
    extends BaseJdbcOutputStore {
        private final URI location;

        PostGISJdbcAdaptor(URI location, DataSource ds, boolean replaceExistingTables) {
            super(ds, replaceExistingTables);
            this.location = location;
        }

        public URI getTableURI(String tableName) {
            return URI.create(String.format("%s?layer=%s", this.location, tableName));
        }

        protected ResultOrProblems<BaseJdbcOutputStore.StructMappingToColumnMapping> toColumnMapping(StructFlattener.StructMapping structMapping, StructFlattener.StructMapping firstGeomMapping, Connection conn) throws ProblemException {
            Class type = structMapping.getType().internalType();
            if (Geometry.class.isAssignableFrom(type)) {
                Referenced referenced = (Referenced)structMapping.getType().findAllowNull(Referenced.class).orElseThrow(() -> new ProblemException((Problems)GeometryProblems.get().notReferenced(structMapping.getType())));
                Optional axisSwapper = AxisSwapper.getForceXY((CoordinateReferenceSystem)referenced.getCrs(), null, (ProblemSink)ProblemSink.DEVNULL);
                CoordinateReferenceSystem crs = axisSwapper.map(AxisSwapper::getNewCrs).orElse(referenced.getCrs());
                int postgisSRID = this.toSridCode(crs, conn);
                WKBWriter geomWriter = new WKBWriter(2, true);
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, String.format("geometry(%s, %d)", type.getSimpleName(), postgisSRID), g -> {
                    Geometry geom = (Geometry)g;
                    return geomWriter.write(this.prepareGeometry(geom, postgisSRID, axisSwapper));
                }));
            }
            if (type == Boolean.class) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "BOOLEAN", Function.identity()));
            }
            if (type == Long.class) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "BIGINT", Function.identity()));
            }
            if (type == Double.class) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "DOUBLE PRECISION", Function.identity()));
            }
            if (type == Date.class) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TIMESTAMP", Function.identity(), Optional.of(93)));
            }
            if (type == String.class) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT", Function.identity()));
            }
            if (structMapping.getType().findAllowNull(RSList.class).map(listType -> listType.find(Text.class)).isPresent()) {
                return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT[]", list -> {
                    List values = (List)list;
                    return values.toArray(new String[values.size()]);
                }));
            }
            return ResultOrProblems.of((Object)new BaseJdbcOutputStore.StructMappingToColumnMapping(structMapping, "TEXT", x -> Objects.toString(x)), (Problem[])new Problem[]{OutputProblems.get().outputTypeAsText(structMapping.getKey(), structMapping.getType(), (PipelineOutputStore)PostGISPipelineOutputStore.this)});
        }

        protected void postTableCreate(String tableName, StructFlattener.StructMapping firstGeomMapping, Connection conn) throws SQLException, ProblemException {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int toSridCode(CoordinateReferenceSystem crs, Connection conn) throws ProblemException {
            try (Statement stmt = conn.createStatement();){
                if (!this.getExistingTableNames(conn.getMetaData()).contains("spatial_ref_sys")) {
                    throw new ProblemException((Problems)POSTGIS_PROBLEMS.databaseNotSpatial());
                }
                Integer epsgCode = null;
                try {
                    epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                }
                catch (FactoryException ex) {
                    log.error("EPSG code lookup failed - crs will not be supported for postgis output", (Throwable)ex);
                }
                if (epsgCode == null) {
                    throw new ProblemException((Problems)OutputProblems.get().unsupportedCrs(crs));
                }
                ResultSet rs = stmt.executeQuery(String.format("select srid from spatial_ref_sys where auth_srid = %d and auth_name like 'EPSG'", epsgCode));
                if (rs.next()) {
                    int n2 = rs.getInt("srid");
                    return n2;
                }
                try (PreparedStatement insertStmt = conn.prepareStatement("insert into spatial_ref_sys values(?, ?, ?, ?)");){
                    insertStmt.setInt(1, epsgCode);
                    insertStmt.setString(2, "EPSG");
                    insertStmt.setInt(3, epsgCode);
                    insertStmt.setString(4, crs.toWKT());
                    insertStmt.execute();
                }
                int n = epsgCode;
                return n;
            }
            catch (SQLException e) {
                throw new RiskscapeException((Problems)Problems.caught((Throwable)e));
            }
        }
    }
}

