/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.postgis;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.postgis.PostGISProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class PostGISConnectionOptions {
    public static final String URI_SCHEME = "postgis";
    public static final String ENV_PGPASSWORD = "PGPASSWORD";
    public static final int DEFAULT_PSQL_PORT = 5432;
    private URI location;
    private String host;
    private int port = 5432;
    private String database;
    private String user;
    private String password;

    public void setLocation(URI fromLocation) {
        String db;
        String userInfo;
        this.location = fromLocation;
        if (!URI_SCHEME.equals(fromLocation.getScheme())) {
            throw new RuntimeException("Not a postgis uri " + String.valueOf(fromLocation));
        }
        if (fromLocation.getPort() != -1) {
            this.port = fromLocation.getPort();
        }
        if (fromLocation.getHost() != null) {
            this.host = fromLocation.getHost();
        }
        if ((userInfo = fromLocation.getUserInfo()) != null) {
            List<String> userParts = Arrays.asList(userInfo.split(":", 2));
            this.user = userParts.get(0);
            if (userParts.size() > 1) {
                this.password = userParts.get(1);
            }
        }
        if ((db = fromLocation.getPath()) != null && db.length() > 0) {
            this.database = db.substring(1, db.length() - (db.endsWith("/") ? 1 : 0));
        }
    }

    public void setEnvironment(Map<String, String> env) {
        if (env.containsKey(ENV_PGPASSWORD)) {
            this.password = env.get(ENV_PGPASSWORD);
        }
    }

    public ResultOrProblems<PostGISConnectionOptions> validate() {
        LinkedList<Problem> problems = new LinkedList<Problem>();
        if (this.location != null && this.location.getHost() == null && this.location.getUserInfo() == null && this.location.getPort() == -1) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PostGISProblems.get().invalidLocation(this.location)});
        }
        if (Strings.isNullOrEmpty((String)this.host)) {
            problems.add(GeneralProblems.get().required((Object)"host"));
        }
        if (Strings.isNullOrEmpty((String)this.user)) {
            problems.add(GeneralProblems.get().required((Object)"user"));
        }
        if (Strings.isNullOrEmpty((String)this.database)) {
            problems.add(GeneralProblems.get().required((Object)"database"));
        }
        if (this.location != null) {
            if (Strings.isNullOrEmpty((String)this.location.getHost()) && !Strings.isNullOrEmpty((String)this.location.getSchemeSpecificPart())) {
                problems.add(PostGISProblems.get().ignoredFromLocation(this.location.getSchemeSpecificPart(), "uri suffix"));
            }
            if (this.location.getUserInfo() != null && this.location.getUserInfo().split(":", 2).length == 2) {
                problems.add(PostGISProblems.get().passwordInClearText());
            }
            if (this.location.getQuery() != null) {
                problems.add(PostGISProblems.get().ignoredFromLocation(this.location.getQuery(), "query"));
            }
            if (this.location.getFragment() != null) {
                problems.add(PostGISProblems.get().ignoredFromLocation(this.location.getFragment(), "fragment"));
            }
        }
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        return ResultOrProblems.of((Object)this, problems);
    }

    public String toJdbcUri() {
        StringBuilder sb = new StringBuilder("jdbc:postgresql://");
        sb.append(this.host);
        sb.append(":").append(this.port);
        sb.append("/").append(this.database).append("?user=").append(this.user);
        if (this.password != null) {
            sb.append("&password=").append(this.password);
        }
        return sb.toString();
    }

    public URI toLocation() {
        String locationString = String.format("postgis://%s@%s:%d/%s", this.user, this.host, this.port, this.database);
        return URI.create(locationString);
    }

    @Generated
    public URI getLocation() {
        return this.location;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public void setDatabase(String database) {
        this.database = database;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public void setUser(String user) {
        this.user = user;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }
}

