/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.algebra.constant;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.algebra.AlgebraDescriptor;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public final class OperationConstOpImage
extends ColormapOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private final boolean hasNoData;
    private Range noData;
    private byte[][] byteLookupTable;
    private final boolean hasROI;
    private ROI roi;
    private final boolean caseA;
    private final boolean caseB;
    private final boolean caseC;
    private AlgebraDescriptor.Operator op;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    private double[] constants;
    private Rectangle roiBounds;
    private PlanarImage roiImage;

    public OperationConstOpImage(RenderedImage source, Map config, ImageLayout layout, AlgebraDescriptor.Operator op, double[] constants, ROI srcROI, Range noData, double destinationNoData) {
        super(source, layout, config, true);
        if (op == null) {
            throw new IllegalArgumentException("Operation Not Defined");
        }
        this.op = op;
        if (!op.supportsMultipleValues()) {
            throw new IllegalArgumentException("Wrong Operation Defined");
        }
        int srcDataType = source.getSampleModel().getDataType();
        int dataType = this.getSampleModel().getDataType();
        if (!op.isDataTypeSupported(srcDataType)) {
            throw new IllegalArgumentException("This operation does not support DataType: " + srcDataType);
        }
        if (constants == null || constants.length == 0) {
            throw new IllegalArgumentException("Constants not defined");
        }
        int numBands = this.getSampleModel().getNumBands();
        if (constants.length < numBands) {
            this.constants = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                this.constants[i] = constants[0];
            }
        } else {
            this.constants = (double[])constants.clone();
        }
        this.destNoDataDouble = destinationNoData;
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                break;
            }
            case 1: {
                this.destNoDataShort = ImageUtil.clampRoundUShort((double)destinationNoData);
                break;
            }
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        if (srcROI != null) {
            this.hasROI = true;
            this.roi = srcROI;
            this.roiBounds = this.roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
        }
        this.caseA = !this.hasNoData && !this.hasROI;
        this.caseB = !this.hasNoData && this.hasROI;
        this.caseC = this.hasNoData && !this.hasROI;
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
        if (dataType == 0) {
            this.initByteTable();
        }
    }

    private void initByteTable() {
        if (this.byteLookupTable != null) {
            return;
        }
        int nbands = this.constants.length;
        this.byteLookupTable = new byte[nbands][256];
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        for (int band = 0; band < nbands; ++band) {
            int k = ImageUtil.clampRoundInt((double)this.constants[band]);
            float kF = (float)this.constants[band];
            byte[] t = this.byteLookupTable[band];
            for (int i = 0; i < 256; ++i) {
                t[i] = this.hasNoData && this.noData.contains((byte)i) ? this.destNoDataByte : (supportsFloat ? ImageUtil.clampRoundByte((float)this.op.calculate(new float[]{i, kF})) : ImageUtil.clampByte((int)this.op.calculate(i, k)));
            }
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor src = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile) {
                    if (!roiTile.intersects(srcRectExpanded)) {
                        roiDisjointTile = true;
                    } else {
                        PlanarImage roiIMG = this.getImage();
                        roiIter = RandomIterFactory.create((RenderedImage)roiIMG, null, (boolean)true, (boolean)true);
                    }
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            switch (dst.getDataType()) {
                case 0: {
                    this.computeRectByte(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 1: {
                    this.computeRectUShort(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 2: {
                    this.computeRectShort(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 3: {
                    this.computeRectInt(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 4: {
                    this.computeRectFloat(src, dst, roiIter, roiContainsTile);
                    break;
                }
                case 5: {
                    this.computeRectDouble(src, dst, roiIter, roiContainsTile);
                }
            }
            if (dst.isDataCopy()) {
                dst.clampDataArrays();
                dst.copyDataToRaster();
            }
        } else {
            double[] bkg = new double[dest.getSampleModel().getNumBands()];
            Arrays.fill(bkg, this.destNoDataDouble);
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])bkg);
        }
    }

    private void computeRectByte(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        byte[][] dData = dst.getByteDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.hasROI && !roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                byte[] d = dData[b];
                byte[] s = srcData[b];
                byte[] bandTable = this.byteLookupTable[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataByte;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = bandTable[s[srcPixelOffset] & 0xFF];
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                byte[] d = dData[b];
                byte[] s = srcData[b];
                byte[] bandTable = this.byteLookupTable[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = bandTable[s[srcPixelOffset] & 0xFF];
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s[srcPixelOffset], cf}) : (short)this.op.calculate(s[srcPixelOffset], c)) : (supportsFloat ? ImageUtil.clampRoundUShort((float)this.op.calculate(new float[]{s[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort((int)this.op.calculate(s[srcPixelOffset] & 0xFFFF, c)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s[srcPixelOffset], cf}) : (short)this.op.calculate(s[srcPixelOffset], c)) : (supportsFloat ? ImageUtil.clampRoundUShort((float)this.op.calculate(new float[]{s[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort((int)this.op.calculate(s[srcPixelOffset] & 0xFFFF, c)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s[srcPixelOffset], cf}) : (short)this.op.calculate(s[srcPixelOffset], c)) : (supportsFloat ? ImageUtil.clampRoundUShort((float)this.op.calculate(new float[]{s[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort((int)this.op.calculate(s[srcPixelOffset] & 0xFFFF, c)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.isUshortSupported() ? (supportsFloat ? (short)this.op.calculate(new float[]{s[srcPixelOffset], cf}) : (short)this.op.calculate(s[srcPixelOffset], c)) : (supportsFloat ? ImageUtil.clampRoundUShort((float)this.op.calculate(new float[]{s[srcPixelOffset] & 0xFFFF, cf})) : ImageUtil.clampUShort((int)this.op.calculate(s[srcPixelOffset] & 0xFFFF, c)));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        short[][] dData = dst.getShortDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsFloat = this.op.isDataTypeSupported(4);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort((float)this.op.calculate(new float[]{s[srcPixelOffset], cf})) : ImageUtil.clampShort((int)this.op.calculate(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort((float)this.op.calculate(new float[]{s[srcPixelOffset], cf})) : ImageUtil.clampShort((int)this.op.calculate(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort((float)this.op.calculate(new float[]{s[srcPixelOffset], cf})) : ImageUtil.clampShort((int)this.op.calculate(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                int c = ImageUtil.clampRoundInt((double)this.constants[b]);
                float cf = (float)this.constants[b];
                short[] d = dData[b];
                short[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataShort;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsFloat ? ImageUtil.clampRoundShort((float)this.op.calculate(new float[]{s[srcPixelOffset], cf})) : ImageUtil.clampShort((int)this.op.calculate(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        int[][] dData = dst.getIntDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        boolean supportsDouble = this.op.isDataTypeSupported(5);
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                long c = ImageUtil.clampRoundInt((double)this.constants[b]);
                int[] d = dData[b];
                int[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt((double)this.op.calculate(s[srcPixelOffset], this.constants[b])) : ImageUtil.clampInt((long)this.op.calculateL(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < dstBands; ++b) {
                long c = ImageUtil.clampRoundInt((double)this.constants[b]);
                int[] d = dData[b];
                int[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt((double)this.op.calculate(s[srcPixelOffset], this.constants[b])) : ImageUtil.clampInt((long)this.op.calculateL(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                long c = ImageUtil.clampRoundInt((double)this.constants[b]);
                int[] d = dData[b];
                int[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt((double)this.op.calculate(s[srcPixelOffset], this.constants[b])) : ImageUtil.clampInt((long)this.op.calculateL(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                long c = ImageUtil.clampRoundInt((double)this.constants[b]);
                int[] d = dData[b];
                int[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataInt;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = supportsDouble ? ImageUtil.clampRoundInt((double)this.op.calculate(s[srcPixelOffset], this.constants[b])) : ImageUtil.clampInt((long)this.op.calculateL(s[srcPixelOffset], c));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        float[][] dData = dst.getFloatDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                float[] d = dData[b];
                float[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = ImageUtil.clampFloat((double)this.op.calculate(s[srcPixelOffset], this.constants[b]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < dstBands; ++b) {
                float[] d = dData[b];
                float[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = ImageUtil.clampFloat((double)this.op.calculate(s[srcPixelOffset], this.constants[b]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                float[] d = dData[b];
                float[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = ImageUtil.clampFloat((double)this.op.calculate(s[srcPixelOffset], this.constants[b]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                float[] d = dData[b];
                float[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataFloat;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = ImageUtil.clampFloat((double)this.op.calculate(s[srcPixelOffset], this.constants[b]));
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dLineStride = dst.getScanlineStride();
        int dPixelStride = dst.getPixelStride();
        int[] dBandOffsets = dst.getBandOffsets();
        double[][] dData = dst.getDoubleDataArrays();
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                double[] d = dData[b];
                double[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        d[dstPixelOffset] = this.op.calculate(s[srcPixelOffset], this.constants[b]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseB) {
            for (int b = 0; b < dstBands; ++b) {
                double[] d = dData[b];
                double[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0) {
                            d[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.calculate(s[srcPixelOffset], this.constants[b]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int b = 0; b < dstBands; ++b) {
                double[] d = dData[b];
                double[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        if (this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.calculate(s[srcPixelOffset], this.constants[b]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        } else {
            for (int b = 0; b < dstBands; ++b) {
                double[] d = dData[b];
                double[] s = srcData[b];
                int dstLineOffset = dBandOffsets[b];
                int srcLineOffset = srcBandOffsets[b];
                for (int h = 0; h < dstHeight; ++h) {
                    int dstPixelOffset = dstLineOffset;
                    int srcPixelOffset = srcLineOffset;
                    dstLineOffset += dLineStride;
                    srcLineOffset += srcLineStride;
                    for (int w = 0; w < dstWidth; ++w) {
                        x0 = srcX + w;
                        y0 = srcY + h;
                        if (!this.roiBounds.contains(x0, y0) || roiIter.getSample(x0, y0, 0) <= 0 || this.noData.contains(s[srcPixelOffset])) {
                            d[dstPixelOffset] = this.destNoDataDouble;
                            dstPixelOffset += dPixelStride;
                            srcPixelOffset += srcPixelStride;
                            continue;
                        }
                        d[dstPixelOffset] = this.op.calculate(s[srcPixelOffset], this.constants[b]);
                        dstPixelOffset += dPixelStride;
                        srcPixelOffset += srcPixelStride;
                    }
                }
            }
        }
    }

    protected void transformColormap(byte[][] colormap) {
        this.initByteTable();
        for (int b = 0; b < 3; ++b) {
            byte[] map = colormap[b];
            byte[] luTable = this.byteLookupTable[b >= this.byteLookupTable.length ? 0 : b];
            int mapSize = map.length;
            for (int i = 0; i < mapSize; ++i) {
                map[i] = luTable[map[i] & 0xFF];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            OperationConstOpImage operationConstOpImage = this;
            synchronized (operationConstOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

