/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.httpclient;

import com.google.common.net.MediaType;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.openstack4j.api.exceptions.ConnectionException;
import org.openstack4j.connectors.httpclient.HttpClientFactory;
import org.openstack4j.core.transport.HttpRequest;
import org.openstack4j.core.transport.ObjectMapperSingleton;
import org.openstack4j.core.transport.functions.EndpointURIFromRequestFunction;

public final class HttpCommand<R> {
    private HttpRequest<R> request;
    private CloseableHttpClient client;
    HttpUriRequest clientReq;
    private int retries;

    private HttpCommand(HttpRequest<R> request) {
        this.request = request;
    }

    public static <R> HttpCommand<R> create(HttpRequest<R> request) {
        HttpCommand<R> command = new HttpCommand<R>(request);
        super.initialize();
        return command;
    }

    private void initialize() {
        URI url = null;
        try {
            url = this.populateQueryParams(this.request);
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(e.getMessage(), e.getIndex(), (Throwable)e);
        }
        this.client = HttpClientFactory.INSTANCE.getClient(this.request.getConfig());
        switch (this.request.getMethod()) {
            case POST: {
                this.clientReq = new HttpPost(url);
                break;
            }
            case PUT: {
                this.clientReq = new HttpPut(url);
                break;
            }
            case DELETE: {
                this.clientReq = new HttpDelete(url);
                break;
            }
            case HEAD: {
                this.clientReq = new HttpHead(url);
                break;
            }
            case PATCH: {
                this.clientReq = new HttpPatch(url);
                break;
            }
            case GET: {
                this.clientReq = new HttpGet(url);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported http method: " + this.request.getMethod());
            }
        }
        this.clientReq.setHeader("Accept", MediaType.JSON_UTF_8.toString());
        this.populateHeaders(this.request);
    }

    public CloseableHttpResponse execute() throws Exception {
        EntityBuilder builder = null;
        if (this.request.getEntity() != null) {
            if (InputStream.class.isAssignableFrom(this.request.getEntity().getClass())) {
                InputStreamEntity ise = new InputStreamEntity((InputStream)this.request.getEntity(), ContentType.create((String)this.request.getContentType()));
                ((HttpEntityEnclosingRequestBase)this.clientReq).setEntity((HttpEntity)ise);
            } else {
                builder = EntityBuilder.create().setContentType(ContentType.create((String)this.request.getContentType(), (String)"UTF-8")).setText(ObjectMapperSingleton.getContext(this.request.getEntity().getClass()).writer().writeValueAsString(this.request.getEntity()));
            }
        } else if (this.request.hasJson()) {
            builder = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(this.request.getJson());
        }
        if (builder != null && this.clientReq instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)this.clientReq).setEntity(builder.build());
        }
        return this.client.execute(this.clientReq);
    }

    public boolean hasEntity() {
        return this.request.getEntity() != null;
    }

    public int getRetries() {
        return this.retries;
    }

    public HttpCommand<R> incrementRetriesAndReturn() {
        this.initialize();
        ++this.retries;
        return this;
    }

    public HttpRequest<R> getRequest() {
        return this.request;
    }

    private URI populateQueryParams(HttpRequest<R> request) throws URISyntaxException {
        URIBuilder uri = new URIBuilder(new EndpointURIFromRequestFunction().apply(request));
        if (!request.hasQueryParams()) {
            return uri.build();
        }
        for (Map.Entry entry : request.getQueryParams().entrySet()) {
            for (Object o : (List)entry.getValue()) {
                uri.addParameter((String)entry.getKey(), String.valueOf(o));
            }
        }
        return uri.build();
    }

    private void populateHeaders(HttpRequest<R> request) {
        if (!request.hasHeaders()) {
            return;
        }
        for (Map.Entry h : request.getHeaders().entrySet()) {
            this.clientReq.addHeader((String)h.getKey(), String.valueOf(h.getValue()));
        }
    }
}

