/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.connectors.httpclient;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openstack4j.connectors.httpclient.HttpClientConfigInterceptor;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.UntrustedSSL;
import org.openstack4j.core.transport.internal.HttpExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    public static final HttpClientFactory INSTANCE = new HttpClientFactory();
    private static final String USER_AGENT = "OpenStack4j-Agent";
    private static final Logger LOG = LoggerFactory.getLogger(HttpExecutor.class);
    private CloseableHttpClient client;
    private static HttpClientConfigInterceptor INTERCEPTOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableHttpClient getClient(Config config) {
        if (this.client == null) {
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                if (this.client == null) {
                    this.client = this.buildClient(config);
                }
            }
        }
        return this.client;
    }

    public static void registerInterceptor(HttpClientConfigInterceptor interceptor) {
        INTERCEPTOR = interceptor;
    }

    private CloseableHttpClient buildClient(Config config) {
        HttpClientBuilder cb = HttpClientBuilder.create().setUserAgent(USER_AGENT);
        if (config.getProxy() != null) {
            try {
                URL url = new URL(config.getProxy().getHost());
                HttpHost proxy = new HttpHost(url.getHost(), config.getProxy().getPort(), url.getProtocol());
                cb.setProxy(proxy);
            }
            catch (MalformedURLException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        if (config.isIgnoreSSLVerification()) {
            cb.setSslcontext(UntrustedSSL.getSSLContext());
            cb.setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
        }
        if (config.getSslContext() != null) {
            cb.setSslcontext(config.getSslContext());
        }
        if (config.getMaxConnections() > 0) {
            cb.setMaxConnTotal(config.getMaxConnections());
        }
        if (config.getMaxConnectionsPerRoute() > 0) {
            cb.setMaxConnPerRoute(config.getMaxConnectionsPerRoute());
        }
        RequestConfig.Builder rcb = RequestConfig.custom();
        if (config.getConnectTimeout() > 0) {
            rcb.setConnectTimeout(config.getConnectTimeout());
        }
        if (config.getReadTimeout() > 0) {
            rcb.setSocketTimeout(config.getReadTimeout());
        }
        if (INTERCEPTOR != null) {
            INTERCEPTOR.onClientCreate(cb, rcb, config);
        }
        return cb.setDefaultRequestConfig(rcb.build()).build();
    }
}

