/*
 * Decompiled with CFR 0.152.
 */
package org.riskscape.cli;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.AttributeDescriptor;

public class FeatureBackedStructMap
implements Map<String, Object> {
    private final SimpleFeature feature;
    private final Set<Map.Entry<String, Object>> entrySet;

    public FeatureBackedStructMap(SimpleFeature feature) {
        this(feature, null);
    }

    public FeatureBackedStructMap(SimpleFeature feature, Set<String> attributeNames) {
        this.feature = feature;
        this.entrySet = feature.getFeatureType().getAttributeDescriptors().stream().filter(ad -> attributeNames == null || attributeNames.contains(ad.getLocalName())).map(ad -> new AttrEntry((AttributeDescriptor)ad)).collect(Collectors.toSet());
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entrySet;
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entrySet.stream().filter(entry -> ((String)entry.getKey()).equals(key)).findAny().isPresent();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        return this.entrySet.stream().filter(entry -> ((String)entry.getKey()).equals(key)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> keySet() {
        return this.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Collection<Object> values() {
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public String toString() {
        return this.entrySet().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    private class AttrEntry
    implements Map.Entry<String, Object> {
        private final AttributeDescriptor ad;

        AttrEntry(AttributeDescriptor ad) {
            this.ad = ad;
        }

        @Override
        public String getKey() {
            return this.ad.getLocalName();
        }

        @Override
        public Object getValue() {
            return FeatureBackedStructMap.this.feature.getAttribute(this.ad.getName());
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry that = (Map.Entry)object;
                return Objects.equal((Object)this.getKey(), that.getKey()) && Objects.equal((Object)this.getValue(), that.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            String k = this.getKey();
            Object v = this.getValue();
            return (k == null ? 0 : k.hashCode()) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + String.valueOf(this.getValue());
        }
    }
}

