/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.parsers.XsdHttpHandler;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.http.HTTPClient;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.PullParser;
import org.geotools.xsd.impl.ParserHandler;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.xml.sax.SAXException;

public class PullParserFeatureReader
implements GetParser<SimpleFeature> {
    private static final Logger LOGGER = Logging.getLogger(PullParserFeatureReader.class);
    private PullParser parser;
    private InputStream inputStream;
    private FeatureType featureType;
    private final String axisOrder;
    GeometryCoordinateSequenceTransformer transformer;
    private long lastLogMessage = 0L;
    private long logCounter = 0L;
    private final long WAIT_LOG = 5000L;
    private XsdHttpHandler httpHandler = null;

    public PullParserFeatureReader(Configuration wfsConfiguration, InputStream getFeatureResponseStream, FeatureType featureType, String axisOrder) throws IOException {
        this.inputStream = getFeatureResponseStream;
        this.featureType = featureType;
        this.axisOrder = axisOrder;
        this.parser = new PullParser(wfsConfiguration, getFeatureResponseStream, new QName(featureType.getName().getNamespaceURI(), featureType.getName().getLocalPart()));
        this.transformer = new GeometryCoordinateSequenceTransformer();
        this.transformer.setMathTransform((MathTransform)new AffineTransform2D(0.0, 1.0, 1.0, 0.0, 0.0, 0.0));
    }

    public PullParserFeatureReader(Configuration wfsConfiguration, InputStream getFeatureResponseStream, FeatureType featureType, String axisOrder, HTTPClient client) throws IOException {
        this(wfsConfiguration, getFeatureResponseStream, featureType, axisOrder);
        this.httpHandler = new XsdHttpHandler(client);
        this.parser.setURIHandler((URIHandler)this.httpHandler);
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
                this.parser = null;
            }
        }
        if (this.httpHandler != null) {
            this.httpHandler.dispose();
        }
    }

    private SimpleFeature toSimpleFeature(Object obj) {
        if (obj instanceof SimpleFeature) {
            return (SimpleFeature)obj;
        }
        if (obj instanceof Map && this.featureType instanceof SimpleFeatureType) {
            Map map = (Map)obj;
            SimpleFeatureType schema = (SimpleFeatureType)this.featureType;
            Object[] values = new Object[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                AttributeDescriptor descriptor = schema.getDescriptor(i);
                String key = descriptor.getLocalName();
                Object value = map.get(key);
                values[i] = value;
            }
            SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)schema, (Object[])values, null);
            return feature;
        }
        return (SimpleFeature)obj;
    }

    public SimpleFeature parse() throws IOException {
        CoordinateReferenceSystem crs;
        Geometry geometry;
        SimpleFeature feature;
        Object parsed;
        try {
            parsed = this.parser.parse();
        }
        catch (XMLStreamException | SAXException e) {
            throw new IOException("Error parsing xml for features of type: " + String.valueOf(this.featureType == null ? "Unknown" : this.featureType.getName()), e);
        }
        if (parsed == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            ++this.logCounter;
            long time = System.currentTimeMillis();
            if (this.lastLogMessage == 0L) {
                LOGGER.fine("First feature parsed.");
                this.lastLogMessage = time;
            } else if (time - this.lastLogMessage > 5000L) {
                LOGGER.fine(String.format("Number of features parsed: %d", this.logCounter));
                this.lastLogMessage = time;
            }
        }
        if ((feature = this.toSimpleFeature(parsed)).getDefaultGeometry() != null && (geometry = (Geometry)feature.getDefaultGeometry()).getUserData() instanceof CoordinateReferenceSystem && WFSConfig.invertAxisNeeded((String)this.axisOrder, (CoordinateReferenceSystem)(crs = (CoordinateReferenceSystem)geometry.getUserData()))) {
            try {
                feature.setDefaultGeometry((Object)this.invertGeometryCoordinates(geometry));
            }
            catch (TransformException e) {
                throw new IOException(e);
            }
        }
        return feature;
    }

    private String entriesInMap(Object parsedMap) {
        if (!(parsedMap instanceof Map)) {
            return parsedMap.toString();
        }
        return ((Map)parsedMap).entrySet().stream().map(e -> (String)e.getKey() + "=" + String.valueOf(e.getValue()) + "\n").collect(Collectors.joining());
    }

    private Geometry invertGeometryCoordinates(Geometry geometry) throws TransformException {
        return this.transformer.transform(geometry);
    }

    public int getNumberOfFeatures() {
        LOGGER.warning("Pull Parser doesn't implement counting features");
        return -1;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
    }

    public void setContextCustomizer(ParserHandler.ContextCustomizer contextCustomizer) {
        this.parser.setContextCustomizer(contextCustomizer);
    }
}

