/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs;

import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.InvertAxisFilterVisitor;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.data.wfs.WFSDiff;
import org.geotools.data.wfs.WFSFeatureReader;
import org.geotools.data.wfs.WFSLocalTransactionState;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.GetParser;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

class WFSFeatureSource
extends ContentFeatureSource {
    private static final Logger LOGGER = Logging.getLogger(WFSFeatureSource.class);
    private final WFSClient client;

    public WFSFeatureSource(ContentEntry entry, WFSClient client) {
        super(entry, null);
        this.client = client;
    }

    WFSClient getWfs() {
        return this.client;
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return false;
    }

    protected boolean canReproject() {
        return true;
    }

    protected boolean canOffset(Query query) {
        return this.client.canOffset();
    }

    protected boolean canSort(Query query) {
        return this.client.canSort();
    }

    protected boolean canRetype(Query query) {
        return this.client.canRetype();
    }

    protected boolean canFilter(Query query) {
        return this.client.canFilter();
    }

    protected boolean canLimit(Query query) {
        return this.client.canLimit();
    }

    public WFSDataStore getDataStore() {
        return (WFSDataStore)super.getDataStore();
    }

    protected Query resolvePropertyNames(Query query) {
        return query;
    }

    protected Filter resolvePropertyNames(Filter filter) {
        return filter;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return null;
        }
        QName remoteTypeName = this.getRemoteTypeName();
        CoordinateReferenceSystem targetCrs = null == query.getCoordinateSystem() ? this.client.getDefaultCRS(remoteTypeName) : query.getCoordinateSystem();
        ReferencedEnvelope bounds = this.client.getBounds(remoteTypeName, targetCrs);
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCountInternal(Query query) throws IOException {
        if (!this.client.canCount()) {
            return -1;
        }
        GetFeatureRequest request = this.createGetFeature(query, GetFeatureRequest.ResultType.HITS);
        GetFeatureResponse response = this.client.issueRequest(request);
        try {
            int resultCount;
            GetParser featureParser = response.getFeatures(null);
            int n = resultCount = featureParser.getNumberOfFeatures();
            return n;
        }
        finally {
            response.dispose();
        }
    }

    private void invertAxisInFilterIfNeeded(Query query, SimpleFeatureType featureType) {
        boolean invertXY;
        CoordinateReferenceSystem crs = query.getCoordinateSystem();
        if (crs == null) {
            crs = featureType.getCoordinateReferenceSystem();
        }
        if (invertXY = WFSConfig.invertAxisNeeded((String)this.client.getAxisOrderFilter(), (CoordinateReferenceSystem)crs)) {
            this.invertAxisInFilter(query);
        }
    }

    private void invertAxisInFilter(Query query) {
        Filter filter = query.getFilter();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        InvertAxisFilterVisitor visitor = new InvertAxisFilterVisitor(ff, new GeometryFactory());
        filter = (Filter)filter.accept((FilterVisitor)visitor, null);
        query.setFilter(filter);
    }

    protected GetFeatureRequest createGetFeature(Query query, GetFeatureRequest.ResultType resultType) throws IOException {
        Integer startIndex;
        GetFeatureRequest request = this.client.createGetFeatureRequest();
        WFSDataStore dataStore = this.getDataStore();
        QName remoteTypeName = dataStore.getRemoteTypeName(this.getEntry().getName());
        SimpleFeatureType remoteSimpleFeatureType = dataStore.getRemoteSimpleFeatureType(remoteTypeName);
        request.setTypeName(remoteTypeName);
        request.setFullType((FeatureType)remoteSimpleFeatureType);
        this.invertAxisInFilterIfNeeded(query, remoteSimpleFeatureType);
        request.setFilter(query.getFilter());
        request.setResultType(resultType);
        request.setHints(query.getHints());
        int maxFeatures = query.getMaxFeatures();
        if (!query.isMaxFeaturesUnlimited() && this.canLimit(query)) {
            request.setMaxFeatures(Integer.valueOf(maxFeatures));
        }
        if ((startIndex = query.getStartIndex()) != null && this.canOffset(query)) {
            request.setStartIndex(startIndex);
        }
        request.setPropertyNames(query.getPropertyNames());
        request.setSortBy(query.getSortBy());
        String srsName = this.getSupportedSrsName(request, query);
        request.setSrsName(srsName);
        LOGGER.fine("request = " + request.toString());
        return request;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query localQuery) throws IOException {
        ContentEntry entry;
        Transaction.State state;
        WFSLocalTransactionState wfsState;
        if (Filter.EXCLUDE.equals(localQuery.getFilter())) {
            LOGGER.fine("Filter is EXCLUDE returning empty collection");
            return new EmptyFeatureReader((FeatureType)this.getSchema());
        }
        GetFeatureRequest request = this.createGetFeature(localQuery, GetFeatureRequest.ResultType.RESULTS);
        CoordinateReferenceSystem crs = localQuery.getCoordinateSystemReproject();
        SimpleFeatureType destType = this.getQueryType(crs, localQuery.getPropertyNames(), this.getSchema());
        SimpleFeatureType contentType = this.getQueryType(crs, request.getPropertyNames(), (SimpleFeatureType)request.getFullType());
        request.setQueryType((FeatureType)contentType);
        LOGGER.fine(() -> "request = " + String.valueOf(request));
        GetFeatureResponse response = this.client.issueRequest(request);
        LOGGER.fine(() -> "response = " + String.valueOf(response));
        GeometryFactory geometryFactory = this.findGeometryFactory(localQuery.getHints());
        GetParser features = response.getSimpleFeatures(geometryFactory);
        MaxFeatureReader reader = new WFSFeatureReader(features, response);
        Filter unsupportedFilter = request.getUnsupportedFilter();
        if (unsupportedFilter != null && unsupportedFilter != Filter.INCLUDE) {
            reader = new FilteringFeatureReader((FeatureReader)reader, unsupportedFilter);
            if (localQuery.getMaxFeatures() < Integer.MAX_VALUE) {
                reader = new MaxFeatureReader(reader, localQuery.getMaxFeatures());
            }
        }
        if (!reader.hasNext()) {
            reader.close();
            return new EmptyFeatureReader((FeatureType)contentType);
        }
        SimpleFeatureType readerType = (SimpleFeatureType)reader.getFeatureType();
        if (!destType.equals(readerType)) {
            boolean cloneContents = false;
            reader = new ReTypeFeatureReader(reader, destType, false);
        }
        reader = this.applyReprojectionDecorator((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, localQuery, request);
        Transaction transaction = this.getTransaction();
        if (!Transaction.AUTO_COMMIT.equals(transaction) && (wfsState = (WFSLocalTransactionState)(state = transaction.getState((Object)(entry = this.getEntry())))) != null) {
            WFSDiff diff = wfsState.getDiff();
            reader = new DiffFeatureReader((FeatureReader)reader, (Diff)diff, localQuery.getFilter());
        }
        return reader;
    }

    protected String getSupportedSrsName(GetFeatureRequest request, Query query) {
        String identifier = GML2EncodingUtils.toURI((CoordinateReferenceSystem)query.getCoordinateSystem(), (SrsSyntax)SrsSyntax.AUTH_CODE, (boolean)false);
        if (identifier == null) {
            return null;
        }
        int idx = identifier.lastIndexOf(58);
        String authority = identifier.substring(0, idx);
        String code = identifier.substring(idx + 1);
        Set supported = request.getStrategy().getSupportedCRSIdentifiers(request.getTypeName());
        for (String supportedSrs : supported) {
            if (!supportedSrs.contains(authority) || !supportedSrs.endsWith(":" + code)) continue;
            return supportedSrs;
        }
        return null;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> applyReprojectionDecorator(FeatureReader<SimpleFeatureType, SimpleFeature> reader, Query query, GetFeatureRequest request) {
        ForceCoordinateSystemFeatureReader tmp = reader;
        if (query.getCoordinateSystem() != null && FeatureTypes.shouldReproject((SimpleFeatureType)((SimpleFeatureType)reader.getFeatureType()), (CoordinateReferenceSystem)query.getCoordinateSystem())) {
            if (request.getSrsName() != null) {
                try {
                    reader = new ForceCoordinateSystemFeatureReader(reader, query.getCoordinateSystem());
                }
                catch (SchemaException e) {
                    LOGGER.warning(e.toString());
                    reader = tmp;
                }
            } else {
                try {
                    reader = new ReprojectFeatureReader(reader, query.getCoordinateSystem());
                }
                catch (Exception e) {
                    LOGGER.warning(e.toString());
                    reader = tmp;
                }
            }
        }
        return reader;
    }

    private GeometryFactory findGeometryFactory(Hints hints) {
        GeometryFactory geomFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (geomFactory == null) {
            CoordinateSequenceFactory seqFac = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            if (seqFac == null) {
                seqFac = PackedCoordinateSequenceFactory.DOUBLE_FACTORY;
            }
            geomFactory = new GeometryFactory(seqFac);
        }
        return geomFactory;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        GeometryDescriptor defaultGeometry;
        WFSDataStore dataStore = this.getDataStore();
        Name localTypeName = this.getEntry().getName();
        QName remoteTypeName = dataStore.getRemoteTypeName(localTypeName);
        SimpleFeatureType remoteSimpleFeatureType = dataStore.getRemoteSimpleFeatureType(remoteTypeName);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(remoteSimpleFeatureType);
        builder.setName(localTypeName);
        String namespaceOverride = this.entry.getName().getNamespaceURI();
        if (namespaceOverride != null) {
            builder.setNamespaceURI(namespaceOverride);
        }
        if ((defaultGeometry = remoteSimpleFeatureType.getGeometryDescriptor()) != null) {
            builder.setDefaultGeometry(defaultGeometry.getLocalName());
            builder.setCRS(defaultGeometry.getCoordinateReferenceSystem());
        }
        SimpleFeatureType adaptedFeatureType = builder.buildFeatureType();
        return adaptedFeatureType;
    }

    public QName getRemoteTypeName() throws IOException {
        Name localTypeName = this.getEntry().getName();
        QName remoteTypeName = this.getDataStore().getRemoteTypeName(localTypeName);
        return remoteTypeName;
    }

    SimpleFeatureType getQueryType(CoordinateReferenceSystem crs, String[] propertyNames, SimpleFeatureType featureType) throws IOException {
        SimpleFeatureType queryType = featureType;
        if (propertyNames != null && propertyNames.length > 0) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames);
            }
            catch (SchemaException e) {
                throw new DataSourceException((Throwable)e);
            }
        } else {
            propertyNames = DataUtilities.attributeNames((SimpleFeatureType)featureType);
        }
        if (crs != null) {
            try {
                queryType = DataUtilities.createSubType((SimpleFeatureType)queryType, (String[])propertyNames, (CoordinateReferenceSystem)crs);
            }
            catch (SchemaException e) {
                throw new DataSourceException((Throwable)e);
            }
        }
        return queryType;
    }

    public ResourceInfo getInfo() {
        try {
            return this.client.getInfo(this.getRemoteTypeName());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unexpected error getting ResourceInfo: ", e);
            return super.getInfo();
        }
    }
}

