/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;

public class ShapefileWriting {
    public static boolean addDbfHeader(Class<?> colType, String colName, DbaseFileHeader dbfHeader) throws DbaseFileException {
        if (colType == Integer.class || colType == Short.class || colType == Byte.class) {
            dbfHeader.addColumn(colName, 'N', 9, 0);
        } else if (colType == Long.class) {
            dbfHeader.addColumn(colName, 'N', 19, 0);
        } else if (colType == BigInteger.class) {
            dbfHeader.addColumn(colName, 'N', 33, 0);
        } else if (colType == Float.class) {
            int l = 24;
            int d = Math.min(Math.max(22, 0), 15);
            dbfHeader.addColumn(colName, 'N', l, d);
        } else if (colType == Double.class) {
            int l = 33;
            int d = Math.min(Math.max(l - 2, 0), 15);
            dbfHeader.addColumn(colName, 'N', l, d);
        } else if (Number.class.isAssignableFrom(colType)) {
            int l = 33;
            int d = Math.max(l - 2, 0);
            dbfHeader.addColumn(colName, 'N', l, d);
        } else if (Date.class.isAssignableFrom(colType) && Boolean.getBoolean("org.geotools.shapefile.datetime")) {
            dbfHeader.addColumn(colName, '@', 255, 0);
        } else if (Date.class.isAssignableFrom(colType) || Calendar.class.isAssignableFrom(colType)) {
            dbfHeader.addColumn(colName, 'D', 255, 0);
        } else if (colType == Boolean.class) {
            dbfHeader.addColumn(colName, 'L', 1, 0);
        } else if (CharSequence.class.isAssignableFrom(colType) || colType == UUID.class) {
            dbfHeader.addColumn(colName, 'C', 254, 0);
        } else {
            dbfHeader.addColumn(colName, 'C', 254, 0);
            return true;
        }
        return false;
    }
}

