/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.problem.ProblemSink;

public class RelationBackedList
extends AbstractList<Tuple> {
    private final Relation relation;
    private ExpensiveResource<Integer> exactSize;

    public RelationBackedList(Relation relation, ProblemSink sink) {
        this.relation = relation;
        this.exactSize = new ExpensiveResource<Integer>(sink, "relation-size", () -> {
            int size = 0;
            Iterator<Tuple> iterator = this.iteratorWithWarningsSuppressed();
            while (iterator.hasNext()) {
                ++size;
                iterator.next();
            }
            return size;
        });
    }

    private Iterator<Tuple> iteratorWithWarningsSuppressed() {
        if (this.relation.hasSkipOnInvalid()) {
            return this.relation.skipInvalid(ProblemSink.DEVNULL).iterator();
        }
        return this.relation.iterator();
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.relation.iterator();
    }

    @Override
    public Tuple get(int index) {
        try {
            Iterator<Tuple> iter = this.iterator();
            for (int ctr = 0; ctr != index; ++ctr) {
                iter.next();
            }
            return iter.next();
        }
        catch (NoSuchElementException ex) {
            throw new IndexOutOfBoundsException("Bad index: " + index);
        }
    }

    @Override
    public int size() {
        return this.exactSize.get();
    }

    @Override
    public boolean isEmpty() {
        return !this.iteratorWithWarningsSuppressed().hasNext();
    }

    @Override
    public void add(int index, Tuple element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Tuple element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super Tuple> c) {
        throw new UnsupportedOperationException();
    }
}

