/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typexp;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.dsl.Lexer;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.dsl.TokenType;
import nz.org.riskscape.dsl.UnexpectedTokenException;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.rl.TokenTypes;

public class Parser {
    private Lexer<TokenTypes> lexer;

    public Parser(String sourceString) {
        this.lexer = new Lexer(TokenTypes.tokens(), sourceString);
    }

    public Parser(Lexer<TokenTypes> lexer) {
        this.lexer = lexer;
    }

    public AST parseAny() {
        switch ((TokenTypes)this.lexer.peekType()) {
            case EOF: {
                return null;
            }
            case STRING: 
            case INTEGER: 
            case DECIMAL: {
                return this.parseConstant();
            }
            case WHITESPACE: {
                this.lexer.next();
                return this.parseAny();
            }
            case IDENTIFIER: 
            case QUOTED_IDENTIFIER: 
            case KEY_IDENTIFIER: {
                return this.parseTypeOrDictionary();
            }
        }
        throw new UnexpectedTokenException(EnumSet.of(TokenTypes.STRING, new TokenTypes[]{TokenTypes.INTEGER, TokenTypes.DECIMAL, TokenTypes.WHITESPACE, TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER, TokenTypes.KEY_IDENTIFIER}), this.lexer.peek());
    }

    private AST parseTypeOrDictionary() {
        switch ((TokenTypes)this.lexer.peekType()) {
            case KEY_IDENTIFIER: {
                return this.parseDictionary(this.lexer.peek());
            }
        }
        return this.parseType();
    }

    private AST.Dictionary parseDictionary(Token start) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        while (this.lexer.peekType() != TokenTypes.RPAREN) {
            Token identifier = this.lexer.expect(new TokenType[]{TokenTypes.KEY_IDENTIFIER});
            this.lexer.expect(new TokenType[]{TokenTypes.COLON});
            AST value = this.parseAny();
            builder.put((Object)new AST.Symbol(identifier), (Object)value);
            if (this.lexer.peekType() != TokenTypes.COMMA) continue;
            this.lexer.next();
        }
        return new AST.Dictionary(start, (Map)builder.build());
    }

    private AST.Constant parseConstant() {
        Token constant = this.lexer.expect(new TokenType[]{TokenTypes.STRING, TokenTypes.INTEGER, TokenTypes.DECIMAL});
        String raw = constant.value;
        return new AST.Constant(constant, switch ((TokenTypes)constant.type) {
            case TokenTypes.STRING -> raw;
            case TokenTypes.INTEGER -> Long.parseLong(raw);
            case TokenTypes.DECIMAL -> Double.parseDouble(raw);
            default -> throw new RuntimeException("unexpected token type - " + String.valueOf(constant));
        });
    }

    public AST parseTypeFromExpression() {
        AST parsed = this.parseType();
        this.lexer.expect(new TokenType[]{TokenTypes.EOF});
        return parsed;
    }

    public AST parseType() {
        Token identifier = this.lexer.expect(new TokenType[]{TokenTypes.IDENTIFIER, TokenTypes.QUOTED_IDENTIFIER});
        if (this.lexer.peekType() == TokenTypes.LPAREN) {
            return new AST.ComplexType(identifier, this.parseArgumentList());
        }
        return new AST.Symbol(identifier);
    }

    private AST.ValueList parseArgumentList() {
        Token start = this.lexer.expect(new TokenType[]{TokenTypes.LPAREN});
        ArrayList<AST> arguments = new ArrayList<AST>();
        while (this.lexer.peekType() != TokenTypes.RPAREN) {
            arguments.add(this.parseAny());
            Token separator = this.lexer.expect(new TokenType[]{TokenTypes.RPAREN, TokenTypes.COMMA});
            if (separator.type != TokenTypes.RPAREN) continue;
            return new AST.ValueList(start, arguments);
        }
        return new AST.ValueList(start, arguments);
    }

    @Generated
    public Parser() {
    }
}

