/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typexp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import nz.org.riskscape.config.ConfigSection;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.ini.IdentifiedObjectBuilder;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typeset.CanonicalType;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.typexp.TypeBuilder;
import nz.org.riskscape.engine.typexp.TypeBuildingException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;

public class IniFileTypeBuilder
extends IdentifiedObjectBuilder.Base<CanonicalType> {
    private final Project project;
    public static final String TYPE = "type";
    public static final String MULTILINE_TYPE_PREFIX = "type.";
    public static final String TYPE_KEY = "type";

    public IniFileTypeBuilder(Project project) {
        super(CanonicalType.class, "type");
        this.project = project;
    }

    public ResultOrProblems<Type> buildType(TypeBuilder builder, ConfigSection sectionValues) {
        ArrayList problems = Lists.newArrayList();
        Consumer<List> addProblems = ps -> problems.addAll(problems);
        String type = sectionValues.getOne("type").map(or -> (String)or.orElse(addProblems, (Object)"")).orElse(null);
        if (!Strings.isNullOrEmpty((String)type)) {
            return this.buildType(builder, type);
        }
        Struct.StructBuilder structBuilder = new Struct.StructBuilder();
        Map map = sectionValues.toMultiMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            if (key.startsWith(MULTILINE_TYPE_PREFIX)) {
                String attrName = key.substring(MULTILINE_TYPE_PREFIX.length());
                if (values.size() > 1) {
                    problems.add(Problem.error((String)"Attribute '%s' has been defined more than once", (Object[])new Object[]{attrName}));
                    continue;
                }
                String typeExpression = (String)values.get(0);
                ResultOrProblems<Type> attrTypeMaybe = this.buildType(builder, typeExpression);
                attrTypeMaybe.ifPresent(attrType -> structBuilder.add(attrName, attrType));
                if (!attrTypeMaybe.hasProblems()) continue;
                problems.add(Problem.composite((List)attrTypeMaybe.getProblems(), (String)"Attribute %s has problems:", (Object[])new Object[]{attrName}));
                continue;
            }
            problems.add(Problem.warning((String)"spurious attribute - %s", (Object[])new Object[]{key}));
        }
        if (Problem.hasErrors((Collection)problems)) {
            return ResultOrProblems.failed((List)problems);
        }
        if (structBuilder.isEmpty()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"requires either a type or type.<ATTR_NAME> entry(s)", (Object[])new Object[0]).withChildren((List)problems)});
        }
        return ResultOrProblems.of((Object)structBuilder.build(), (List)problems);
    }

    private ResultOrProblems<Type> buildType(TypeBuilder builder, String typeExpression) {
        try {
            return ResultOrProblems.of((Object)builder.build(typeExpression));
        }
        catch (TypeBuildingException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)ex)});
        }
        catch (RuntimeException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)ex, (String)"Unexpected error building type from '%s' - %s", (Object[])new Object[]{typeExpression, ex.getMessage()})});
        }
    }

    @Override
    public ResultOrProblems<CanonicalType> build(String id, ConfigSection section) {
        return this.buildType(this.project.getTypeBuilder(), section).map(type -> new CanonicalType(id, (Type)type){

            public TypeSet getTypeSet() {
                return IniFileTypeBuilder.this.project.getTypeSet();
            }
        });
    }
}

