/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.typexp;

import lombok.Generated;
import nz.org.riskscape.dsl.LexerException;
import nz.org.riskscape.dsl.ParseException;
import nz.org.riskscape.engine.FailedObjectException;
import nz.org.riskscape.engine.NoSuchObjectException;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeInformation;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.engine.typexp.AST;
import nz.org.riskscape.engine.typexp.BadTypeExpressionException;
import nz.org.riskscape.engine.typexp.LookupConstructor;
import nz.org.riskscape.engine.typexp.Parser;
import nz.org.riskscape.engine.typexp.TypeBuilder;
import nz.org.riskscape.engine.typexp.UnknownTypeException;

public class DefaultTypeBuilder
implements TypeBuilder {
    private final TypeSet typeSet;

    public Type build(String typeExpression) {
        AST type;
        Parser parser = new Parser(typeExpression);
        try {
            type = parser.parseTypeFromExpression();
        }
        catch (LexerException | ParseException e) {
            throw new BadTypeExpressionException(typeExpression, (RiskscapeException)e);
        }
        return this.expectType(type, ast -> new BadTypeExpressionException(typeExpression, "did not result in a type", null));
    }

    public Type buildComplexType(AST.ComplexType type) {
        if (type.ident().equals("lookup")) {
            return LookupConstructor.INSTANCE.construct((TypeBuilder)this, type);
        }
        try {
            TypeInformation typeInfo = (TypeInformation)this.typeSet.getTypeRegistry().get(type.ident());
            return typeInfo.getConstructor().construct((TypeBuilder)this, type);
        }
        catch (FailedObjectException | NoSuchObjectException e) {
            throw new UnknownTypeException(type);
        }
    }

    public Type buildSimpleType(AST.Symbol symbol) {
        try {
            TypeInformation typeInfo = (TypeInformation)this.typeSet.getTypeRegistry().get(symbol.ident());
            return typeInfo.getConstructor().construct((TypeBuilder)this, symbol);
        }
        catch (FailedObjectException | NoSuchObjectException e) {
            throw new UnknownTypeException(symbol);
        }
    }

    @Generated
    public DefaultTypeBuilder(TypeSet typeSet) {
        this.typeSet = typeSet;
    }

    @Generated
    public TypeSet getTypeSet() {
        return this.typeSet;
    }
}

