/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.tiff;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import lombok.Generated;
import nz.org.riskscape.engine.tiff.SparseTIFFImageReader;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.Position2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparseTiffCoverage
extends GridCoverage2D {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparseTiffCoverage.class);
    private final SparseTIFFImageReader imageReader = SparseTIFFImageReader.initialize(this);
    private final double[] noData;
    private final MathTransform2D crsToGrid2D;
    private final Rectangle imageBounds;

    public static GridCoverage createIfSupported(GridCoverage coverage, File file) {
        if (coverage instanceof GridCoverage2D) {
            GridCoverage2D grid2d = (GridCoverage2D)coverage;
            try {
                NoDataContainer noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)grid2d);
                if (noData == null) {
                    log.info("Sparse tiff support not enabled, missing nodata: {}", (Object)file);
                    return coverage;
                }
            }
            catch (Exception e) {
                log.warn("Sparse tiff support not enabled, exception: {}", (Object)file, (Object)e);
                return coverage;
            }
            log.info("Using sparse tiff support for {}", (Object)file);
            return new SparseTiffCoverage((CharSequence)grid2d.getName(), grid2d);
        }
        log.info("Sparse tiff support not enabled for {}", (Object)file);
        return coverage;
    }

    public SparseTiffCoverage(CharSequence name, GridCoverage2D coverage) {
        super(name, coverage);
        this.noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage).getAsArray();
        this.crsToGrid2D = this.getGridGeometry().getCRSToGrid2D();
        this.imageBounds = this.image.getBounds();
    }

    public double[] evaluate(Position coord, double[] dest) {
        int y;
        int x;
        Position2D translated = new Position2D();
        try {
            this.crsToGrid2D.transform(coord, (Position)translated);
        }
        catch (MismatchedDimensionException | TransformException | InvalidGridGeometryException e) {
            throw new CannotEvaluateException("Could not transform coordinate", e);
        }
        double fx = translated.getX();
        double fy = translated.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy) && this.imageBounds.contains(x = (int)Math.round(fx), y = (int)Math.round(fy))) {
            int tileY;
            int tileX = this.image.XToTileX(x);
            if (this.imageReader.isEmptyTile(tileX, tileY = this.image.YToTileY(y))) {
                return this.noData;
            }
            return this.image.getTile(tileX, tileY).getPixel(x, y, dest);
        }
        return this.noData;
    }

    public double[] evaluate(GridCoordinates2D coord, double[] dest) {
        int x = coord.x;
        int y = coord.y;
        if (this.imageBounds.contains(x, y)) {
            int tileY;
            int tileX = this.image.XToTileX(x);
            if (this.imageReader.isEmptyTile(tileX, tileY = this.image.YToTileY(y))) {
                return this.noData;
            }
            return this.image.getTile(tileX, tileY).getPixel(x, y, dest);
        }
        return this.noData;
    }

    void sampleAPixelForInit() {
        Rectangle2D rectangle2d = this.getGridGeometry().getGridRange2D().getBounds2D();
        super.evaluate(new GridCoordinates2D((int)rectangle2d.getCenterX(), (int)rectangle2d.getCenterY()), new double[2]);
    }

    @Generated
    public double[] getNoData() {
        return this.noData;
    }
}

