/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFField;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.BitSet;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import lombok.Generated;
import nz.org.riskscape.engine.tiff.SparseTiffCoverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparseTIFFImageReader
extends TIFFImageReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparseTIFFImageReader.class);
    private static final int MAX_FIND_NODATA_TILE_ATTEMPTS = 3;
    private static final int MAX_MIN_TILE_SIZE = 10240;
    private final BitSet noDataTiles = new BitSet();
    private int firstImageIndex = -1;
    private boolean runningInit = false;

    public static SparseTIFFImageReader initialize(SparseTiffCoverage coverage) {
        RenderedImage renderedImage = coverage.getRenderedImage();
        ImageReader reader = (ImageReader)renderedImage.getProperty("JAI.ImageReader");
        if (reader instanceof SparseTIFFImageReader) {
            SparseTIFFImageReader tiffReader = (SparseTIFFImageReader)((Object)reader);
            tiffReader.initNoDataInfo(() -> coverage.sampleAPixelForInit());
            if (tiffReader.firstImageIndex == -1) {
                throw new AssertionError((Object)"Image index was not set during initialization!");
            }
            return tiffReader;
        }
        throw new IllegalArgumentException("Wrong ImageReader class, can not initialize " + String.valueOf(reader));
    }

    public SparseTIFFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    void initialize(int imageIndex) {
        this.initNoDataInfo(() -> {
            this.firstImageIndex = imageIndex;
        });
    }

    private void initNoDataInfo(Runnable callback) {
        this.runningInit = true;
        try {
            callback.run();
        }
        finally {
            this.runningInit = false;
        }
        if (this.planarConfiguration == 2) {
            throw new UnsupportedOperationException("SparseTiff NotSupported with planar images");
        }
        try {
            this.recordNoDataTiles();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEmptyTile(int tileX, int tileY) {
        int tileIndex = tileY * this.tilesAcross + tileX;
        return this.noDataTiles.get(tileIndex);
    }

    public boolean hasEmptyTiles() {
        return !this.noDataTiles.isEmpty();
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (this.firstImageIndex != imageIndex) {
            if (this.firstImageIndex == -1) {
                if (this.runningInit) {
                    this.firstImageIndex = imageIndex;
                }
            } else {
                throw new IllegalStateException("Saw wrong image index - " + imageIndex + " is not " + this.firstImageIndex);
            }
        }
        return super.read(imageIndex, param);
    }

    private void recordNoDataTiles() throws IOException {
        long[] byteCounts = this.getByteCounts();
        if (byteCounts.length == 0) {
            return;
        }
        for (int idx = 0; idx < byteCounts.length; ++idx) {
            if (byteCounts[idx] != 0L) continue;
            this.noDataTiles.set(idx);
        }
        if (this.noDataTiles.cardinality() > 0) {
            if (log.isDebugEnabled()) {
                log.info("Sparse TIFF has {}/{} empty tiles", (Object)this.noDataTiles.cardinality(), (Object)byteCounts.length);
            }
            return;
        }
        this.scanForNoDataTiles(byteCounts);
    }

    private long[] getByteCounts() throws IOException {
        this.getWidth(this.firstImageIndex);
        TIFFField f = this.imageMetadata.getTIFFField(325);
        if (f == null) {
            f = this.imageMetadata.getTIFFField(279);
        }
        if (f == null) {
            f = this.imageMetadata.getTIFFField(514);
        }
        if (f == null) {
            return new long[0];
        }
        return this.getAsLongs(f);
    }

    private long[] getAsLongs(TIFFField field) {
        return IntStream.range(0, Array.getLength(field.getData())).mapToLong(arg_0 -> ((TIFFField)field).getAsLong(arg_0)).toArray();
    }

    private void scanForNoDataTiles(long[] tileByteCounts) throws IOException {
        if (this.noData == null) {
            log.debug("TIFF is missing no-data metadata, can not apply no-data optimizations");
            return;
        }
        long minLong = (int)LongStream.of(tileByteCounts).min().orElse(Long.MAX_VALUE);
        if (minLong > 10240L) {
            log.debug("Skipping scanning for no-data tiles, no tiles are less than {} bytes", (Object)10240);
            return;
        }
        int min = (int)minLong;
        this.tilesAcross = (this.width + this.tileOrStripWidth - 1) / this.tileOrStripWidth;
        this.tilesDown = (this.height + this.tileOrStripHeight - 1) / this.tileOrStripHeight;
        log.debug("Scanning {} tiles looking for size {} for no-data", (Object)tileByteCounts.length, (Object)min);
        byte[] noDataTileBytes = this.findNoDataTile(tileByteCounts, min);
        if (noDataTileBytes == null) {
            log.debug("No-data ({}) tile not found", (Object)this.noData);
            return;
        }
        byte[] tileBuffer = new byte[min];
        for (int tileIndex = 0; tileIndex < tileByteCounts.length; ++tileIndex) {
            if (tileByteCounts[tileIndex] != (long)min) continue;
            long offset = this.getTileOrStripOffset(tileIndex);
            this.stream.seek(offset);
            int read = this.stream.read(tileBuffer);
            if (read != min) {
                throw new IOException("Failed to read %d bytes from image stream %s - corrupt tiff?".formatted(read, this.stream));
            }
            if (!Arrays.equals(noDataTileBytes, tileBuffer)) continue;
            this.noDataTiles.set(tileIndex);
        }
        log.info("Found {} no-data tiles after scanning {}", (Object)this.noDataTiles.cardinality(), (Object)this.stream);
    }

    private byte[] findNoDataTile(long[] tileByteCounts, int min) throws IOException {
        byte[] tileBuffer = new byte[min];
        int attempts = 0;
        block0: for (int tileIndex = 0; tileIndex < tileByteCounts.length; ++tileIndex) {
            if (attempts > 3) {
                log.debug("Exceeded number of attempts ({}) to find no data tile, giving up", (Object)3);
                return null;
            }
            if (tileByteCounts[tileIndex] != (long)min) continue;
            int tileX = tileIndex % this.tilesAcross;
            int tileY = tileIndex / this.tilesDown;
            BufferedImage tile = this.readTile(this.firstImageIndex, tileX, tileY);
            DataBuffer buffer = tile.getData().getDataBuffer();
            for (int bi = 0; bi < buffer.getSize(); ++bi) {
                if (buffer.getElemDouble(bi) == this.noData.doubleValue()) continue;
                ++attempts;
                continue block0;
            }
            long offset = this.getTileOrStripOffset(tileIndex);
            this.stream.seek(offset);
            int read = this.stream.read(tileBuffer);
            if (read != min) {
                throw new IOException("Failed to read %d bytes from image stream %s - corrupt tiff?".formatted(read, this.stream));
            }
            return tileBuffer;
        }
        return null;
    }
}

