/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Reservoir;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import nz.org.riskscape.engine.HasMeter;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.task.PageReader;
import nz.org.riskscape.engine.task.PageWriter;
import nz.org.riskscape.engine.task.ReadPageBuffer;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.TaskState;
import nz.org.riskscape.engine.task.WritePageBuffer;

public abstract class WorkerTask
implements AutoCloseable {
    protected final TaskSpec spec;
    protected final int id;
    protected final PageWriter pageWriter;
    protected final PageReader pageReader;
    private final ExecutionContext context;
    protected final Meter in;
    protected final Meter out;
    protected final Counter runtime;
    protected final Histogram runtimeAverage;
    protected final Counter contextSwitches;
    protected Object processingResult;
    private TaskState state = TaskState.CREATED;

    public WorkerTask(TaskSpec spec) {
        this.spec = spec;
        this.context = spec.getExecutionContext();
        this.id = spec.getWorkerTasks().size() + 1;
        this.pageReader = spec.getInput().map(b -> new PageReader((ReadPageBuffer)b)).orElse(null);
        this.pageWriter = spec.getOutput().map(b -> new PageWriter((WritePageBuffer)b)).orElse(null);
        this.in = this.pageReader != null ? spec.newMetric("tuples-in", "in", () -> new Meter()) : null;
        this.out = this.pageWriter != null ? spec.newMetric("tuples-out", "out", () -> new Meter()) : null;
        this.runtime = spec.newMetric("runtime", () -> new Counter());
        this.runtimeAverage = spec.newMetric("runtime-average", () -> new Histogram((Reservoir)new ExponentiallyDecayingReservoir()));
        this.contextSwitches = spec.newMetric("context-switches", () -> new Counter());
        for (RealizedStep step : spec.getForSteps()) {
            Realized realized = (Realized)step.getResult().get();
            if (!(realized instanceof HasMeter)) continue;
            HasMeter hasMeter = (HasMeter)realized;
            for (String keyMetric : hasMeter.getProgressMetricNames()) {
                spec.getProgressMetrics().put(step.getStepName() + "-" + keyMetric, (Metric)hasMeter.getRegistry().getMetrics().get(keyMetric));
            }
        }
    }

    public abstract ReturnState run();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnState runPublic() {
        long startTime = System.nanoTime();
        try {
            ReturnState returnState = this.run();
            return returnState;
        }
        finally {
            long stopTime = System.nanoTime();
            long runtimeMillis = TimeUnit.MILLISECONDS.convert(stopTime - startTime, TimeUnit.NANOSECONDS);
            this.runtime.inc(runtimeMillis);
            this.runtimeAverage.update(runtimeMillis);
        }
    }

    public Optional<PageReader> getPageReader() {
        return Optional.ofNullable(this.pageReader);
    }

    public Optional<PageWriter> getPageWriter() {
        return Optional.ofNullable(this.pageWriter);
    }

    protected boolean hasInputPage() {
        return this.getPageReader().map(PageReader::hasPageInProgress).orElse(false);
    }

    protected boolean hasOutputPage() {
        return this.getPageWriter().map(PageWriter::hasPageInProgress).orElse(false);
    }

    public boolean hasPageInProgress() {
        return this.hasInputPage() || this.hasOutputPage();
    }

    private boolean isInputComplete() {
        return this.getPageReader().map(PageReader::isComplete).orElse(false);
    }

    public final boolean isInputReady() {
        boolean hasInput = this.getPageReader().map(PageReader::hasInput).orElse(true);
        return hasInput || this.isInputComplete();
    }

    public final boolean isOutputReady() {
        boolean noMoreOutput = this.isInputComplete();
        boolean hasSpace = this.getPageWriter().map(PageWriter::hasSpace).orElse(true);
        return hasSpace || noMoreOutput;
    }

    public boolean isReadyToRun() {
        return !this.spec.hasOutstandingDependencies() && this.isInputReady() && this.isOutputReady();
    }

    protected ReturnState taskComplete() {
        this.getPageWriter().ifPresent(PageWriter::flushPage);
        return ReturnState.COMPLETE;
    }

    public RealizedStep getLastStep() {
        List<RealizedStep> steps = this.spec.getForSteps();
        return steps.get(steps.size() - 1);
    }

    public RealizedStep getFirstStep() {
        return this.spec.getForSteps().get(0);
    }

    protected Realized getFirstStepRealizedResult() {
        return (Realized)this.getFirstStep().getResult().get();
    }

    public String toString() {
        return String.format("%s-%d(steps=%s, input=%s, output=%s)", this.getClass().getSimpleName(), this.id, this.spec.getStepsSummary(), this.getPageReader().orElse(null), this.getPageWriter().orElse(null));
    }

    @Override
    public void close() {
    }

    public boolean isCreated() {
        return this.state == TaskState.CREATED;
    }

    public boolean isStarted() {
        return this.state == TaskState.STARTED;
    }

    public boolean isComplete() {
        return this.state == TaskState.COMPLETE;
    }

    public final String getName() {
        return this.spec.getCombinedStepsName() + "." + this.getClass().getSimpleName().toLowerCase() + "-" + this.id;
    }

    public String getSpecNameBrief() {
        return this.spec.getFirstStep().getStepName();
    }

    public abstract boolean producesResult();

    public Object consumeProcessingResult() {
        Object result = this.processingResult;
        this.processingResult = null;
        return result;
    }

    public void markStarted() {
        this.state = TaskState.STARTED;
        this.contextSwitches.inc();
    }

    public void markComplete() {
        this.state = TaskState.COMPLETE;
    }

    @Generated
    public WorkerTask() {
        this.spec = null;
        this.id = 0;
        this.pageWriter = null;
        this.pageReader = null;
        this.context = null;
        this.in = null;
        this.out = null;
        this.runtime = null;
        this.runtimeAverage = null;
        this.contextSwitches = null;
    }

    @Generated
    public TaskSpec getSpec() {
        return this.spec;
    }

    @Generated
    public ExecutionContext getContext() {
        return this.context;
    }
}

