/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.TupleInput;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.engine.util.PercentGauge;

public class TupleInputTask
extends WorkerTask {
    private final TupleInput input = (TupleInput)this.getFirstStepRealizedResult();

    public TupleInputTask(TaskSpec spec) {
        super(spec);
        this.input.size().ifPresent(size -> spec.newMetric("complete", "complete", () -> new PercentGauge(() -> this.out.getCount(), () -> size)));
    }

    @Override
    public ReturnState run() {
        while (!this.input.isComplete()) {
            if (this.pageWriter.isFull()) {
                return ReturnState.OUTPUT_FULL;
            }
            Tuple next = this.input.poll();
            if (next == null) {
                return ReturnState.INPUT_EMPTY;
            }
            this.pageWriter.add(next);
            this.out.mark();
        }
        return this.taskComplete();
    }

    @Override
    public void close() {
        this.input.close();
    }

    @Override
    public boolean producesResult() {
        return false;
    }
}

