/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.output.PipelineJobContext;
import nz.org.riskscape.engine.output.PipelineOutputContainer;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.sched.Scheduler;
import nz.org.riskscape.engine.task.ReadPageBuffer;
import nz.org.riskscape.engine.task.TaskState;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.engine.task.WritePageBuffer;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;

public final class TaskSpec
implements MetricSet {
    public static final int NO_MINIMUM = 0;
    private final Class<? extends WorkerTask> impl;
    private final List<RealizedStep> forSteps;
    private final List<TaskSpec> dependsOn = new ArrayList<TaskSpec>();
    private final List<TaskSpec> dependsOnSatisified = new ArrayList<TaskSpec>();
    private final Map<TaskSpec, List<Object>> dependencyResults = Maps.newHashMap();
    private final ReadPageBuffer input;
    private final WritePageBuffer output;
    private final boolean parallelizable;
    private final PipelineJobContext jobContext;
    private final String name;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private final List<WorkerTask> workerTasks = new ArrayList<WorkerTask>();
    protected final Map<String, Metric> progressMetrics = new HashMap<String, Metric>();
    private TaskState state = TaskState.CREATED;

    public TaskSpec(Class<? extends WorkerTask> impl, List<RealizedStep> forSteps, ReadPageBuffer input, WritePageBuffer output, boolean parallelizable, PipelineJobContext context) {
        this.impl = impl;
        this.forSteps = forSteps;
        this.input = input;
        this.output = output;
        this.parallelizable = parallelizable;
        this.jobContext = context;
        this.name = impl.getSimpleName() + "+" + this.getCombinedStepsName();
    }

    public Optional<ReadPageBuffer> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<WritePageBuffer> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public Class<? extends WorkerTask> getWorkerTaskClass() {
        return this.impl;
    }

    public void addDependency(TaskSpec task) {
        this.dependsOn.add(task);
    }

    public boolean hasDependency(TaskSpec taskSpec) {
        return this.dependsOn.contains(taskSpec);
    }

    public void satisfyDependency(TaskSpec dependency) {
        if (this.dependsOn.remove(dependency)) {
            this.dependsOnSatisified.add(dependency);
        }
    }

    public boolean hasOutstandingDependencies() {
        return !this.dependsOn.isEmpty();
    }

    public void addProcessingResultFromDependency(TaskSpec fromSpec, Object processingResult) {
        this.dependencyResults.computeIfAbsent(fromSpec, s -> new ArrayList()).add(processingResult);
    }

    public <T> List<T> getProcessingResultsFrom(Class<? extends WorkerTask> taskType, Class<T> expectedType) {
        return this.getProcessingResultsFrom(taskType, expectedType, 0);
    }

    public <T> List<T> getProcessingResultsFrom(Class<? extends WorkerTask> taskType, Class<T> expectedType, int min) {
        ArrayList results = new ArrayList();
        this.dependencyResults.entrySet().forEach(entry -> {
            List values;
            if (taskType.isAssignableFrom(((TaskSpec)entry.getKey()).impl) && (values = (List)entry.getValue()).size() > 0) {
                for (Object value : values) {
                    results.add(expectedType.cast(value));
                }
            }
        });
        if (results.size() < min) {
            throw new IllegalStateException("Expected to have at least " + min + " dependency(ies) from task " + String.valueOf(taskType) + " but had " + results.size());
        }
        return results;
    }

    public <T> T getProcessingResultFrom(Class<? extends WorkerTask> taskType, Class<T> expectedType) {
        List<T> results = this.getProcessingResultsFrom(taskType, expectedType, -1);
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new IllegalStateException("Expected to have a single dependency from task " + String.valueOf(taskType) + " but had " + results.size());
    }

    public WorkerTask newWorkerTask(Scheduler scheduler) throws ProblemException {
        WorkerTask newTask;
        Constructor<? extends WorkerTask> taskClass;
        try {
            taskClass = this.impl.getConstructor(TaskSpec.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RiskscapeException(String.format("WorkerTask %s is missing an appropriate constructor", this.impl.getSimpleName()), (Throwable)e);
        }
        try {
            newTask = taskClass.newInstance(this);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            RiskscapeException rsException;
            if (e.getCause() instanceof ProblemException) {
                throw (ProblemException)e.getCause();
            }
            if (e.getCause() instanceof RiskscapeException && (rsException = (RiskscapeException)e.getCause()).hasProblem()) {
                throw new ProblemException((Problems)rsException.getProblem());
            }
            throw new RiskscapeException(String.format("Failed to create WorkerTask for TaskSpec %s", this.toString()), (Throwable)e);
        }
        this.workerTasks.add(newTask);
        return newTask;
    }

    protected <T extends Metric> T newMetric(String metricName, Supplier<T> constructor) {
        return this.newMetric(metricName, null, constructor);
    }

    protected <T extends Metric> T newMetric(String metricName, String progressName, Supplier<T> constructor) {
        if (this.metrics.containsKey(metricName)) {
            return (T)this.metrics.get(metricName);
        }
        Metric constructed = (Metric)constructor.get();
        this.metrics.put(metricName, constructed);
        if (progressName != null) {
            this.progressMetrics.put(progressName, constructed);
        }
        return (T)constructed;
    }

    public String getCombinedStepsName() {
        return this.forSteps.stream().map(RealizedStep::getStepName).collect(Collectors.joining("+"));
    }

    public String getStepsSummary() {
        return this.forSteps.stream().map(rs -> rs.getStepName()).collect(Collectors.joining(", "));
    }

    public String toString() {
        return String.format("%s(%s)", this.impl.getSimpleName(), this.getStepsSummary());
    }

    public RealizedStep getLastStep() {
        return this.forSteps.get(this.forSteps.size() - 1);
    }

    public RealizedStep getFirstStep() {
        return this.forSteps.get(0);
    }

    public void changeState(TaskState newState) {
        if (newState.ordinal() <= this.state.ordinal()) {
            throw new IllegalStateException("can not change from " + String.valueOf((Object)this.state) + " to " + String.valueOf((Object)newState));
        }
        this.state = newState;
    }

    public boolean isCreated() {
        return this.state == TaskState.CREATED;
    }

    public boolean isStarted() {
        return this.state == TaskState.STARTED;
    }

    public boolean isComplete() {
        return this.state == TaskState.COMPLETE;
    }

    public void close() {
        this.forSteps.forEach(RealizedStep::close);
        this.dependencyResults.clear();
    }

    public boolean hadDependency(TaskSpec taskSpec) {
        return this.dependsOnSatisified.contains(taskSpec);
    }

    public boolean allWorkersMatch(Predicate<WorkerTask> predicate) {
        return this.workerTasks.stream().allMatch(predicate);
    }

    public ExecutionContext getExecutionContext() {
        return this.jobContext.getExecutionContext();
    }

    public PipelineOutputContainer getContainer() {
        return this.jobContext.getOutputContainer();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskSpec)) {
            return false;
        }
        TaskSpec other = (TaskSpec)o;
        Class<? extends WorkerTask> this$impl = this.impl;
        Class<? extends WorkerTask> other$impl = other.impl;
        if (this$impl == null ? other$impl != null : !this$impl.equals(other$impl)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends WorkerTask> $impl = this.impl;
        result = result * 59 + ($impl == null ? 43 : $impl.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public List<RealizedStep> getForSteps() {
        return this.forSteps;
    }

    @Generated
    public List<TaskSpec> getDependsOn() {
        return this.dependsOn;
    }

    @Generated
    public boolean isParallelizable() {
        return this.parallelizable;
    }

    @Generated
    public PipelineJobContext getJobContext() {
        return this.jobContext;
    }

    @Generated
    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    @Generated
    public List<WorkerTask> getWorkerTasks() {
        return this.workerTasks;
    }

    @Generated
    public Map<String, Metric> getProgressMetrics() {
        return this.progressMetrics;
    }

    @Generated
    public TaskState getState() {
        return this.state;
    }
}

