/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import com.codahale.metrics.Meter;
import java.util.function.Consumer;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.problem.ProblemException;

public class SinkTask
extends WorkerTask {
    public final Sink sink;
    private final Meter full;

    public SinkTask(TaskSpec spec) throws ProblemException {
        super(spec);
        SinkConstructor constructor = (SinkConstructor)this.getFirstStepRealizedResult();
        this.sink = (Sink)constructor.newInstance(spec.getJobContext()).drainWarnings((Consumer)spec.getExecutionContext().getProject().getProblemSink()).getOrThrow();
        this.full = spec.newMetric("full", () -> new Meter());
    }

    public RealizedStep getRealizedStep() {
        return this.getSpec().getForSteps().get(0);
    }

    @Override
    public boolean isReadyToRun() {
        return this.sink.canAccept() && this.pageReader.hasInput() || this.pageReader.isComplete();
    }

    @Override
    public ReturnState run() {
        while (!this.pageReader.isComplete()) {
            Tuple tuple = this.pageReader.peek();
            if (tuple == null) {
                return ReturnState.INPUT_EMPTY;
            }
            this.in.mark();
            if (!this.sink.accept(tuple)) {
                this.full.mark();
                return ReturnState.OUTPUT_FULL;
            }
            this.pageReader.next();
        }
        this.sink.finish();
        this.processingResult = this.sink;
        return this.taskComplete();
    }

    @Override
    public boolean producesResult() {
        return true;
    }

    @Override
    public String getSpecNameBrief() {
        return super.getSpecNameBrief() + "-sink";
    }

    @Generated
    public Sink getSink() {
        return this.sink;
    }
}

