/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.sched.Page;
import nz.org.riskscape.engine.task.WritePageBuffer;

public class PageWriter {
    private final WritePageBuffer output;
    private Page page = null;
    private long tuplesWritten = 0L;
    private long pagesWritten = 0L;

    public boolean hasPageInProgress() {
        return this.page != null;
    }

    public boolean isFull() {
        return !this.hasPageInProgress() && this.output.isFull();
    }

    public boolean hasSpace() {
        return !this.isFull();
    }

    public void flushPage() {
        if (this.page != null) {
            this.output.add(this.page);
        }
        this.page = null;
    }

    public void add(Tuple tuple) {
        if (this.page == null) {
            this.page = this.newPage();
        }
        this.page.add(tuple);
        ++this.tuplesWritten;
        if (this.isCurrentPageFull()) {
            this.flushPage();
        }
    }

    private Page newPage() {
        ++this.pagesWritten;
        return this.output.newPage();
    }

    private boolean isCurrentPageFull() {
        return this.page.isFull();
    }

    public String toString() {
        Object info = String.format("[Tuples: total=%d, this-task=%d, %d pages", this.output.numTuplesWritten(), this.tuplesWritten, this.pagesWritten);
        if (this.page != null) {
            info = (String)info + ", current=" + this.page.toString();
        }
        if (this.output.isFull()) {
            info = (String)info + " (buffer full)";
        }
        return (String)info + "]";
    }

    @Generated
    public PageWriter(WritePageBuffer output) {
        this.output = output;
    }

    @Generated
    public long getTuplesWritten() {
        return this.tuplesWritten;
    }

    @Generated
    public long getPagesWritten() {
        return this.pagesWritten;
    }
}

