/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.sched.Page;
import nz.org.riskscape.engine.task.ReadPageBuffer;

public class PageReader
implements TupleIterator {
    private final ReadPageBuffer input;
    private Page.ReadOnlyPage page = null;
    private long tuplesRead = 0L;
    private long pagesRead = 0L;

    public boolean hasPageInProgress() {
        return this.page != null;
    }

    public boolean hasInput() {
        return this.hasPageInProgress() || !this.input.isEmpty();
    }

    public boolean isComplete() {
        return !this.hasPageInProgress() && this.input.isComplete();
    }

    private boolean hasNextTuple() {
        return this.hasPageInProgress() && this.page.hasNext();
    }

    private boolean readNextPage() {
        this.page = this.input.read();
        if (this.page != null) {
            ++this.pagesRead;
        }
        return this.page != null;
    }

    private boolean checkTupleAvailable() {
        return this.hasNextTuple() || this.readNextPage();
    }

    public Tuple peek() {
        if (!this.checkTupleAvailable()) {
            return null;
        }
        return this.page.peek();
    }

    public Tuple next() {
        if (!this.checkTupleAvailable()) {
            return null;
        }
        Tuple tuple = this.page.next();
        ++this.tuplesRead;
        if (!this.hasNextTuple()) {
            this.page = null;
        }
        return tuple;
    }

    public boolean hasNext() {
        return this.checkTupleAvailable();
    }

    public String toString() {
        Object info = String.format("[Tuples: total=%d, this-task=%d, %d pages", this.input.numTuplesRead(), this.tuplesRead, this.pagesRead);
        if (this.page != null) {
            info = (String)info + ", current=" + this.page.toString();
        }
        if (this.input.isComplete()) {
            info = (String)info + " (complete)";
        } else if (this.input.isEmpty()) {
            info = (String)info + " (empty)";
        }
        return (String)info + "]";
    }

    @Generated
    public PageReader(ReadPageBuffer input) {
        this.input = input;
    }

    @Generated
    public long getTuplesRead() {
        return this.tuplesRead;
    }

    @Generated
    public long getPagesRead() {
        return this.pagesRead;
    }
}

