/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;

public class LinkedSteps {
    private final List<RealizedStep> grouped;
    private final List<LinkedSteps> predecessors;
    private final List<LinkedSteps> descendants = new ArrayList<LinkedSteps>();

    public LinkedSteps(List<LinkedSteps> predecessors, List<RealizedStep> steps) {
        this.predecessors = predecessors;
        this.grouped = steps;
        for (LinkedSteps predecessor : predecessors) {
            predecessor.descendants.add(this);
        }
    }

    public RealizedStep getLastStep() {
        return this.grouped.get(this.grouped.size() - 1);
    }

    public boolean containsOnly(Class<? extends Realized> lookFor) {
        return this.grouped.stream().allMatch(step -> step.getStepType().equals(lookFor));
    }

    public LinkedSteps getOrderedPredecessor(int index) {
        RealizedStep previousStep = (RealizedStep)this.getFirstStep().getDependencies().get(index);
        for (LinkedSteps linkedSteps : this.predecessors) {
            if (!linkedSteps.grouped.contains(previousStep)) continue;
            return linkedSteps;
        }
        throw new RuntimeException("Could not find " + String.valueOf(previousStep) + " amongst " + String.valueOf(this.predecessors));
    }

    public RealizedStep getFirstStep() {
        return this.grouped.get(0);
    }

    public boolean hasFanOut() {
        return this.descendants.size() > 1;
    }

    @Generated
    public List<RealizedStep> getGrouped() {
        return this.grouped;
    }

    @Generated
    public List<LinkedSteps> getPredecessors() {
        return this.predecessors;
    }

    @Generated
    public List<LinkedSteps> getDescendants() {
        return this.descendants;
    }

    @Generated
    public String toString() {
        return "LinkedSteps(grouped=" + String.valueOf(this.getGrouped()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkedSteps)) {
            return false;
        }
        LinkedSteps other = (LinkedSteps)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<RealizedStep> this$grouped = this.getGrouped();
        List<RealizedStep> other$grouped = other.getGrouped();
        return !(this$grouped == null ? other$grouped != null : !((Object)this$grouped).equals(other$grouped));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LinkedSteps;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RealizedStep> $grouped = this.getGrouped();
        result = result * 59 + ($grouped == null ? 43 : ((Object)$grouped).hashCode());
        return result;
    }
}

