/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import com.codahale.metrics.Meter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.Sink;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.restriction.Restrictor;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultComputationException;

public class ChainTask
extends WorkerTask {
    private final List<NamedOp> operations;
    private final List<StackElement> visitStack = Lists.newArrayList();
    private StackElement currentElement;
    private Meter tuplesSunk;

    public ChainTask(TaskSpec spec) throws ProblemException {
        super(spec);
        try {
            this.operations = spec.getForSteps().stream().map(rs -> new NamedOp(rs.getStepName(), this.getOp((RealizedStep)rs))).collect(Collectors.toList());
        }
        catch (ResultComputationException ex) {
            throw new ProblemException((Problems)ex.getProblem());
        }
        if (this.pageWriter == null) {
            this.tuplesSunk = spec.newMetric("tuples-sunk", () -> new Meter());
        }
    }

    private Object getOp(RealizedStep rs) {
        Realized r = (Realized)rs.getResult().get();
        if (r instanceof SinkConstructor) {
            Sink sink = (Sink)((SinkConstructor)r).newInstance(this.getSpec().getJobContext()).get();
            if (!sink.isUnbounded()) {
                throw new IllegalArgumentException("SinkConstructor returned a bounded sink - not allowed");
            }
            return sink;
        }
        return r;
    }

    private boolean finishedLastPage() {
        return this.currentElement == null;
    }

    @Override
    public boolean hasPageInProgress() {
        return !this.finishedLastPage() || super.hasPageInProgress();
    }

    @Override
    public boolean isReadyToRun() {
        boolean isReady;
        if (this.pageWriter == null) {
            isReady = this.isInputReady();
        } else {
            boolean hasStackElement = !this.finishedLastPage() && this.pageWriter.hasSpace();
            isReady = hasStackElement || super.isReadyToRun();
        }
        return isReady;
    }

    @Override
    public ReturnState run() {
        while (!this.isFull()) {
            if (this.finishedLastPage()) {
                if (this.pageReader.isComplete()) {
                    if (this.getLastOperation().op instanceof Sink) {
                        this.processingResult = this.getLastOperation().op;
                        ((Sink)this.processingResult).finish();
                    }
                    return this.taskComplete();
                }
                if (!this.pageReader.hasNext()) {
                    return ReturnState.INPUT_EMPTY;
                }
            }
            this.processPage();
        }
        return ReturnState.OUTPUT_FULL;
    }

    private boolean isFull() {
        return this.pageWriter != null && this.pageWriter.isFull();
    }

    private void processPage() {
        if (this.currentElement == null) {
            this.currentElement = new StackElement(this.pageReader, 0);
        }
        block0: while (!this.isFull()) {
            if (!this.currentElement.source.hasNext()) {
                this.currentElement.source.close();
                if (this.visitStack.isEmpty()) {
                    this.currentElement = null;
                    break;
                }
                this.currentElement = this.visitStack.remove(this.visitStack.size() - 1);
                continue;
            }
            Tuple transforming = (Tuple)this.currentElement.source.next();
            if (this.visitStack.isEmpty()) {
                this.in.mark();
            }
            for (int i = this.currentElement.stepIndex; i < this.operations.size(); ++i) {
                Object op = this.operations.get((int)i).op;
                if (op instanceof Projector) {
                    transforming = (Tuple)((Projector)op).apply((Object)transforming);
                    continue;
                }
                if (op instanceof Restrictor) {
                    boolean skip;
                    boolean bl = skip = !((Restrictor)op).test((Object)transforming);
                    if (!skip) continue;
                    transforming = null;
                    continue block0;
                }
                if (op instanceof FlatProjector) {
                    TupleIterator flatProjecting = ((FlatProjector)op).apply(transforming);
                    if (flatProjecting.hasNext()) {
                        transforming = (Tuple)flatProjecting.next();
                        if (flatProjecting.hasNext()) {
                            this.visitStack.add(this.currentElement);
                            this.currentElement = new StackElement(flatProjecting, i + 1);
                            continue;
                        }
                        flatProjecting.close();
                        continue;
                    }
                    flatProjecting.close();
                    continue block0;
                }
                if (op instanceof Sink) {
                    boolean accepted = ((Sink)op).accept(transforming);
                    this.tuplesSunk.mark();
                    if (!accepted) {
                        throw new IllegalStateException("sink is full - not supposed to happen");
                    }
                    transforming = null;
                    continue block0;
                }
                throw new RiskscapeException("Bad step type " + String.valueOf(op));
            }
            if (transforming == null) continue;
            this.out.mark();
            this.pageWriter.add(transforming);
        }
    }

    @Override
    public void close() {
        if (this.currentElement != null) {
            this.currentElement.source.close();
        }
        for (StackElement stackElement : this.visitStack) {
            stackElement.source.close();
        }
    }

    @Override
    public boolean producesResult() {
        return this.getLastOperation().op instanceof Sink;
    }

    public NamedOp getLastOperation() {
        return this.operations.get(this.operations.size() - 1);
    }

    @Override
    public String getSpecNameBrief() {
        if (this.spec.getForSteps().size() > 1) {
            return "steps-" + this.spec.getFirstStep().getStepName() + "~>" + this.spec.getLastStep().getStepName();
        }
        return super.getSpecNameBrief();
    }

    @Generated
    public List<NamedOp> getOperations() {
        return this.operations;
    }

    public static class StackElement {
        public final TupleIterator source;
        public final int stepIndex;

        @Generated
        public StackElement(TupleIterator source, int stepIndex) {
            this.source = source;
            this.stepIndex = stepIndex;
        }
    }

    public static class NamedOp {
        public final String name;
        public final Object op;

        public String toString() {
            return String.format("%s", this.name);
        }

        @Generated
        public NamedOp(String name, Object op) {
            this.name = name;
            this.op = op;
        }
    }
}

