/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.task;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.sched.AccumulatorSink;
import nz.org.riskscape.engine.task.ReturnState;
import nz.org.riskscape.engine.task.TaskSpec;
import nz.org.riskscape.engine.task.WorkerTask;
import nz.org.riskscape.engine.util.PercentGauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorProcessorTask<T>
extends WorkerTask {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccumulatorProcessorTask.class);
    private TupleIterator iterator;
    private Collector<T> collector;
    private final PercentGauge completionGuage;
    private long totalTuples = 0L;

    public AccumulatorProcessorTask(TaskSpec spec) {
        super(spec);
        this.collector = (Collector)spec.getFirstStep().getRealized(Collector.class).get();
        this.completionGuage = spec.newMetric("complete", "complete", () -> new PercentGauge(() -> this.out.getCount(), () -> this.totalTuples));
    }

    @Override
    public boolean isReadyToRun() {
        return !this.spec.hasOutstandingDependencies() && this.isOutputReady();
    }

    @Override
    public ReturnState run() {
        if (this.iterator == null) {
            List<AccumulatorSink> sinks = this.spec.getProcessingResultsFrom(WorkerTask.class, AccumulatorSink.class, 1);
            if (sinks.size() > 1) {
                log.info("About to reduce {} accumulators...", (Object)sinks.size());
            }
            Object accumulated = sinks.stream().map(sink -> this.collector.getAccumulatorClass().cast(sink.getAndClearAccumulator(this.collector))).reduce((a, b) -> this.collector.combine(a, b)).orElse(null);
            if (sinks.size() > 1) {
                log.info("   ...done");
            }
            this.totalTuples = this.collector.size(accumulated).orElse(0L);
            this.iterator = this.collector.process(accumulated);
        }
        while (this.iterator.hasNext()) {
            if (this.pageWriter.isFull()) {
                return ReturnState.OUTPUT_FULL;
            }
            this.out.mark();
            this.pageWriter.add((Tuple)this.iterator.next());
            this.iterator.remove();
        }
        return this.taskComplete();
    }

    @Override
    public boolean producesResult() {
        return false;
    }

    @Override
    protected ReturnState taskComplete() {
        this.iterator = null;
        return super.taskComplete();
    }
}

