/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.problem.SeverityLevel;
import nz.org.riskscape.engine.relation.UnnestProjection;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.rl.ast.PropertyAccess;

public class UnnestStep
extends BaseStep<Parameters> {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public UnnestStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        AtomicBoolean deprecatedSyntax = new AtomicBoolean(false);
        ListDeclaration toUnnestList = ExpressionParser.INSTANCE.toList(parameters.toUnnest);
        List<String> toUnnest = toUnnestList.getElements().stream().map(expr -> expr.isA(Constant.class).map(constant -> {
            deprecatedSyntax.set(true);
            return constant.getToken().value;
        }).orElseGet(() -> expr.toSource())).collect(Collectors.toList());
        ArrayList<Problem> toUnnestProblems = new ArrayList<Problem>();
        for (Expression unnest : toUnnestList.getElements()) {
            if (unnest.isA(PropertyAccess.class).isPresent() || unnest.isA(Constant.class).isPresent()) continue;
            toUnnestProblems.add(ExpressionProblems.get().mismatch(unnest, PropertyAccess.class, "list"));
        }
        if (!toUnnestProblems.isEmpty()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)"to-unnest", toUnnestProblems)});
        }
        ArrayList<Problem> warnings = new ArrayList<Problem>();
        if (deprecatedSyntax.get()) {
            boolean isList = parameters.toUnnest.isA(ListDeclaration.class).isPresent();
            String replacementToUnnest = toUnnest.stream().collect(Collectors.joining(", ", isList ? "[" : "", isList ? "]" : ""));
            warnings.add(PROBLEMS.deprecatedSyntax(String.format("unnest(to-unnest: %s)", parameters.toUnnest.toSource()), String.format("unnest(to-unnest: %s)", replacementToUnnest)));
        }
        return new UnnestProjection(toUnnest, parameters.indexKey, parameters.emitEmpty).getFlatProjector(parameters.input.getProduces()).withMoreProblems(warnings);
    }

    public static class Parameters {
        @Input
        public RealizedStep input;
        @ParameterField
        public Expression toUnnest;
        @ParameterField
        public Optional<String> indexKey;
        @ParameterField
        public boolean emitEmpty = false;
        public RealizationInput rInput;
    }

    public static interface LocalProblems
    extends ProblemFactory {
        @SeverityLevel(value=Problem.Severity.WARNING)
        public Problem deprecatedSyntax(String var1, String var2);
    }
}

