/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.projection.UnionProjector;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class UnionStep
extends BaseStep<Parameters> {
    public UnionStep(Engine engine) {
        super(engine, (Range<Integer>)Range.atLeast((Comparable)Integer.valueOf(2)), Collections.emptyList());
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        return UnionProjector.realize(parameters.rInput.getRealizationContext().getTypeSet(), parameters.inputs.stream().map(input -> input.getProduces()).collect(Collectors.toList()));
    }

    @Override
    protected ResultOrProblems<Parameters> bindInputs(Parameters parameters, List<RealizedStep> inputs) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (inputs.size() < 2) {
            Problem arityError = GeneralProblems.get().badArity(Input.class, (Object)this, this.getInputArity(), inputs.size());
            if (inputs.size() == 1) {
                problems.add(arityError.withSeverity(Problem.Severity.WARNING));
            } else {
                return ResultOrProblems.failed((Problem[])new Problem[]{arityError});
            }
        }
        parameters.inputs = inputs;
        return ResultOrProblems.of((Object)parameters, problems);
    }

    public static class Parameters {
        @Input
        public List<RealizedStep> inputs;
        public RealizationInput rInput;
    }
}

