/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.SourceLocation;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.ExecutionContext;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.relation.EmptyRelation;
import nz.org.riskscape.engine.resource.Resource;
import nz.org.riskscape.engine.resource.ResourceLoadingException;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.pipeline.PipelineParser;
import nz.org.riskscape.pipeline.ast.PipelineDeclaration;
import nz.org.riskscape.pipeline.ast.StepLink;
import nz.org.riskscape.pipeline.ast.StepReference;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ParameterToken;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class SubpipelineStep
extends BaseStep<Parameters> {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    public static final String STEP_REF_IN = "in";
    public static final String STEP_REF_OUT = "out";
    private final ThreadLocal<Queue<URI>> recursionStack = ThreadLocal.withInitial(() -> new ArrayDeque());

    public SubpipelineStep(Engine engine) {
        super(engine, (Range<Integer>)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), List.of());
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        throw new UnsupportedOperationException();
    }

    private ResultOrProblems<Parameters> validateParameters(Parameters params) {
        if (params.parameters.isPresent()) {
            StructDeclaration sd = params.parameters.get();
            for (StructDeclaration.Member member : sd.getMembers()) {
                if (!member.getName().isEmpty()) continue;
                Token location = member.getExpression().getBoundary().map(Pair::getLeft).orElse(Token.UNKNOWN_LOCATION);
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.parametersNotNamed(location).withChildren(new Problems[]{PROBLEMS.parametersNotNamedHint()})});
            }
        }
        return ResultOrProblems.of((Object)params);
    }

    private ResultOrProblems<PipelineDeclaration> replaceParameters(PipelineDeclaration ast, StructDeclaration replacements) {
        HashMap<String, Expression> replacementsMap = new HashMap<String, Expression>();
        for (StructDeclaration.Member member : replacements.getMembers()) {
            replacementsMap.put((String)member.getName().get(), member.getExpression());
        }
        Map<String, ParameterToken> requiredNamesToTokens = ast.findParameters().keySet().stream().collect(Collectors.toMap(ParameterToken::getValue, token -> token));
        Sets.SetView missing = Sets.difference(requiredNamesToTokens.keySet(), replacementsMap.keySet());
        if (!missing.isEmpty()) {
            List<Problem> hints = missing.stream().map(name -> PROBLEMS.missingParameterHint((String)name, ((ParameterToken)requiredNamesToTokens.get(name)).getToken().getLocation())).toList();
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.missingParameters(ast.getMetadata().getLocation(), (Set<String>)missing).withChildren(hints)});
        }
        Sets.SetView surplus = Sets.difference(replacementsMap.keySet(), requiredNamesToTokens.keySet());
        List<Problem> warnings = surplus.stream().map(parameterName -> ParamProblems.get().ignored(parameterName)).toList();
        return ResultOrProblems.of((Object)((PipelineDeclaration)ast.replaceParameters(replacementsMap).get()), warnings);
    }

    private ResultOrProblems<Resource> loadSubpipeline(Parameters params) {
        try {
            return ResultOrProblems.of((Object)this.getEngine().getResourceFactory().load(params.location));
        }
        catch (ResourceLoadingException ex) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)this.getParameterSet().get("location"), (Problems)Problems.caught((Throwable)ex))});
        }
    }

    private ResultOrProblems<PipelineDeclaration> parseChildPipeline(Resource pipelineResource, Parameters params) {
        return PipelineParser.parseParameterizedPipeline((Resource)pipelineResource).flatMap(ast -> {
            if (ast.getChains().isEmpty()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.empty()});
            }
            return this.replaceParameters((PipelineDeclaration)ast, params.parameters.orElse(new StructDeclaration(List.of(), Optional.empty())));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultOrProblems<ChildPipeline> realizeChildPipeline(RealizationInput input, PipelineDeclaration pipeline) {
        if (this.recursionStack.get().contains(pipeline.getMetadata().getLocation())) {
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.recursion(pipeline.getMetadata().getLocation())});
        }
        try {
            RealizedStep outStep;
            RealizedPipeline newPipeline;
            List<RealizedStep> endSteps;
            boolean hasStepRefIn;
            this.recursionStack.get().add(pipeline.getMetadata().getLocation());
            int numDependencies = input.getDependencies().size();
            if (numDependencies > 1) {
                throw new AssertionError((Object)"Realization should not allow this");
            }
            List inStepRefs = pipeline.findAll((ignored, sd) -> sd.isA(StepReference.class).map(sr -> sr.getIdent().equals(STEP_REF_IN)).orElse(false));
            boolean bl = hasStepRefIn = !inStepRefs.isEmpty();
            if (hasStepRefIn) {
                StepLink toIn = null;
                block7: for (PipelineDeclaration.Found f : inStepRefs) {
                    for (int i = 0; i < f.getChain().getLinkCount(); ++i) {
                        StepLink link = f.getChain().getLink(i);
                        if (!STEP_REF_IN.equals(link.getRhs().getIdent())) continue;
                        toIn = link;
                        break block7;
                    }
                }
                if (toIn != null) {
                    ResultOrProblems resultOrProblems = ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.chainingToIn(toIn.getBoundary().map(Pair::getRight).orElse(Token.UNKNOWN_LOCATION))});
                    return resultOrProblems;
                }
            }
            RealizedPipeline startFromPipeline = RealizedPipeline.empty((ExecutionContext)input.getExecutionContext(), (PipelineDeclaration)pipeline);
            RealizedStep originalInputStep = null;
            RealizedStep stubInputStep = null;
            if (numDependencies == 1) {
                originalInputStep = (RealizedStep)input.getDependencies().get(0);
                stubInputStep = RealizedStep.named((String)STEP_REF_IN).withResult((Realized)new EmptyRelation(originalInputStep.getProduces()));
                startFromPipeline = startFromPipeline.add(stubInputStep);
                if (!hasStepRefIn) {
                    ResultOrProblems i = ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.inStepRefMissing(originalInputStep.getStepName())});
                    return i;
                }
            } else if (hasStepRefIn) {
                ResultOrProblems i = ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.inStepRefButNoInput()});
                return i;
            }
            if ((endSteps = (newPipeline = input.getExecutionContext().getPipelineRealizer().realize(startFromPipeline, pipeline)).getEndSteps().stream().filter(rs -> rs.getProduces().size() > 0).toList()).size() == 0) {
                outStep = RealizedStep.named((String)STEP_REF_OUT).withResult((Realized)new EmptyRelation(Struct.EMPTY_STRUCT));
            } else if (endSteps.size() == 1) {
                outStep = endSteps.get(0);
            } else {
                outStep = endSteps.stream().filter(rs -> rs.getName().equals(STEP_REF_OUT)).findFirst().orElse(null);
                if (outStep == null) {
                    List<Token> candidates = endSteps.stream().map(step -> step.getAst().getNameToken().orElse(step.getAst().getIdentToken())).sorted((lhs, rhs) -> lhs.getLocation().compareTo(rhs.getLocation())).toList();
                    ResultOrProblems resultOrProblems = ResultOrProblems.failed((Problem[])new Problem[]{Problems.foundWith((Object)"pipeline", (Problems)PROBLEMS.ambiguousOutput(candidates, PROBLEMS.ambiguousOutputHint()))});
                    return resultOrProblems;
                }
            }
            ResultOrProblems resultOrProblems = ResultOrProblems.of((Object)new ChildPipeline(newPipeline, originalInputStep, stubInputStep, outStep));
            return resultOrProblems;
        }
        finally {
            this.recursionStack.get().remove();
        }
    }

    private RealizedPipeline insertChildIntoParent(RealizationInput input, ChildPipeline child, List<Problem> warnings) {
        RealizedStep failed;
        RealizedPipeline addTo = input.getRealizedPipeline();
        if (child.realized.hasFailures()) {
            failed = input.newPrototypeStep().withProblems(new Problem[]{PROBLEMS.childFailed(child.realized.getAst().getMetadata().getLocation(), (Problem[])child.realized.getFailures().toArray(Problem[]::new))});
            addTo = addTo.add(failed);
        } else {
            failed = null;
        }
        LinkedList<RealizedStep> visitStack = new LinkedList<RealizedStep>(child.realized.getRealizedSteps());
        String childStepPrefix = input.newPrototypeStep().getName() + ".";
        HashMap<RealizedStep, RealizedStep> rebuilt = new HashMap<RealizedStep, RealizedStep>();
        if (child.hasInput()) {
            rebuilt.put(child.renamedInput, child.originalInput);
            visitStack.remove(child.renamedInput);
        }
        int cycleDetect = 0;
        block0: while (!visitStack.isEmpty()) {
            RealizedStep childStep = (RealizedStep)visitStack.removeFirst();
            RealizedStep renamed = childStep.withName(childStepPrefix + childStep.getName());
            ArrayList<RealizedStep> rebuiltDependencies = new ArrayList<RealizedStep>(childStep.getDependencies().size());
            for (RealizedStep originalDependency : childStep.getDependencies()) {
                RealizedStep rebuiltDependency = (RealizedStep)rebuilt.get(originalDependency);
                if (rebuiltDependency == null) {
                    visitStack.add(childStep);
                    if (cycleDetect == visitStack.size()) {
                        throw new AssertionError((Object)("cycle detected " + String.valueOf(visitStack)));
                    }
                    ++cycleDetect;
                    continue block0;
                }
                rebuiltDependencies.add(rebuiltDependency);
            }
            if (failed != null) {
                rebuiltDependencies.add(failed);
            }
            cycleDetect = 0;
            RealizedStep rebuiltStep = renamed.withDependencies(rebuiltDependencies);
            addTo = addTo.add(rebuiltStep);
            rebuilt.put(childStep, rebuiltStep);
        }
        if (failed != null) {
            return addTo;
        }
        if (!child.outputStep.getProduces().equals((Object)Struct.EMPTY_STRUCT)) {
            Projector noop = Projector.identity((Struct)child.outputStep.getProduces());
            addTo = addTo.add(input.newPrototypeStep().withResult((Realized)noop).withProblems(warnings).withDependencies(new RealizedStep[]{(RealizedStep)rebuilt.get(child.outputStep)}));
        }
        return addTo;
    }

    @Override
    public RealizedPipeline realize(RealizationInput input) {
        return (RealizedPipeline)this.buildParametersObject(input).flatMap(params -> this.validateParameters((Parameters)params)).flatMap(params -> this.loadSubpipeline((Parameters)params).flatMap(pipelineResource -> this.parseChildPipeline((Resource)pipelineResource, (Parameters)params).flatMap(pipeline -> this.realizeChildPipeline(input, (PipelineDeclaration)pipeline)).composeProblems((severity, problems) -> Problems.foundWith((Object)params.location, (List)problems)))).flatMap((child, warnings) -> ResultOrProblems.of((Object)this.insertChildIntoParent(input, (ChildPipeline)child, (List<Problem>)warnings))).orElseGet(problems -> input.getRealizedPipeline().add(input.newPrototypeStep().withProblems(problems)));
    }

    public static class Parameters {
        @ParameterField
        public URI location;
        @ParameterField
        public Optional<StructDeclaration> parameters;
        public RealizationInput input;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public Problem ambiguousOutput(List<Token> var1, Problem ... var2);

        public Problem ambiguousOutputHint();

        public Problem empty();

        public Problem missingParameters(URI var1, Set<String> var2);

        public Problem missingParameterHint(String var1, SourceLocation var2);

        public Problem inStepRefMissing(String var1);

        public Problem inStepRefButNoInput();

        public Problem chainingToIn(Token var1);

        public Problem childFailed(URI var1, Problem ... var2);

        public Problem parametersNotNamed(Token var1);

        public Problem parametersNotNamedHint();

        public Problem recursion(URI var1);
    }

    private static class ChildPipeline {
        final RealizedPipeline realized;
        final RealizedStep originalInput;
        final RealizedStep renamedInput;
        final RealizedStep outputStep;

        boolean hasInput() {
            return this.originalInput != null;
        }

        @Generated
        public ChildPipeline(RealizedPipeline realized, RealizedStep originalInput, RealizedStep renamedInput, RealizedStep outputStep) {
            this.realized = realized;
            this.originalInput = originalInput;
            this.renamedInput = renamedInput;
            this.outputStep = outputStep;
        }
    }
}

