/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.sort.SortBy;
import nz.org.riskscape.engine.sort.TupleComparator;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.typexp.BadTypeExpressionException;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.ListDeclaration;
import nz.org.riskscape.util.ListUtils;

public class SortStep
extends BaseStep<Parameters> {
    public SortStep(Engine engine) {
        super(engine);
    }

    private Type normalize(RealizationContext context, Type given) {
        return Nullable.rewrap((Type)given, type -> type.findAllowNull(Struct.class).map(s -> context.normalizeStruct(s)).orElse((Type)type));
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        return ProblemException.catching(() -> {
            Optional<RealizedExpression> deltaExpression;
            Struct sourceType = parameters.input.getProduces();
            SortBy sortBy = this.buildSortBy(parameters);
            Project project = parameters.rInput.getExecutionContext().getProject();
            Type previousInputType = null;
            Struct deltaInput = sourceType;
            if (parameters.deltaType.isPresent()) {
                RealizationContext realizationContext = parameters.rInput.getRealizationContext();
                try {
                    previousInputType = this.normalize(realizationContext, project.getTypeBuilder().build(parameters.deltaType.get()));
                }
                catch (BadTypeExpressionException e) {
                    throw new ProblemException((Problems)e.getProblem());
                }
                deltaInput = sourceType.add(parameters.deltaAttribute.get(), previousInputType);
            }
            if (parameters.delta.isPresent()) {
                deltaExpression = Optional.of(this.realizeDeltaExpression(parameters.delta.get(), deltaInput, sourceType, parameters.rInput.getRealizationContext()));
                if (previousInputType != null) {
                    Type actualReturnType = deltaExpression.get().getResultType();
                    if (!project.getTypeSet().isAssignable(actualReturnType, previousInputType)) {
                        throw new ProblemException((Problems)LocalProblems.get().deltaTypeDifferentToActual(previousInputType, actualReturnType));
                    }
                }
            } else {
                deltaExpression = Optional.empty();
            }
            Struct targetType = this.getTargetType(parameters.input.getProduces(), deltaExpression, parameters.deltaAttribute);
            boolean cascade = parameters.deltaType.isPresent();
            return (InMemorySortCollector)TupleComparator.createComparator(sourceType, sortBy, parameters.rInput.getExecutionContext().getExpressionRealizer()).map(c -> new InMemorySortCollector(parameters.input.getProduces(), targetType, (Comparator<Tuple>)c, deltaExpression, cascade)).getOrThrow();
        });
    }

    private SortBy buildSortBy(Parameters parameters) throws ProblemException {
        ArrayList<SortBy> sortBys = new ArrayList<SortBy>();
        ListDeclaration sortByAsList = ExpressionParser.INSTANCE.toList(parameters.by);
        for (int i = 0; i < sortByAsList.getElements().size(); ++i) {
            Expression expr = (Expression)sortByAsList.getElements().get(i);
            SortBy.Direction dir = SortBy.Direction.ASC;
            if (parameters.direction.size() > i) {
                dir = parameters.direction.get(i);
            }
            sortBys.add(new SortBy(expr, dir));
        }
        return SortBy.concatenate(sortBys);
    }

    private Struct getTargetType(Struct sourceType, Optional<RealizedExpression> deltaExpression, Optional<String> deltaAttribute) throws ProblemException {
        Struct targetType = sourceType;
        if (deltaExpression.isPresent()) {
            if (targetType.getEntry(deltaAttribute.get()) != null) {
                throw new ProblemException((Problems)LocalProblems.get().deltaAttributeAlreadyExists(deltaAttribute.get(), sourceType));
            }
            targetType = targetType.add(deltaAttribute.get(), deltaExpression.get().getResultType());
        }
        return targetType;
    }

    private RealizedExpression realizeDeltaExpression(Lambda lambda, Struct prevType, Struct currType, RealizationContext context) throws ProblemException {
        LambdaType type = LambdaType.create((Lambda)lambda);
        if (type.getArgs().size() != 2) {
            throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError((Expression)lambda, type.getArgs().size(), 2));
        }
        Struct lambdaInput = Struct.of((String)((String)type.getArgs().get(0)), (Type)Nullable.of((Type)prevType), (String)((String)type.getArgs().get(1)), (Type)currType);
        return (RealizedExpression)context.getExpressionRealizer().realize((Type)lambdaInput, lambda.getExpression()).getOrThrow();
    }

    public static class Parameters {
        @Input
        RealizedStep input;
        @ParameterField
        Expression by;
        @ParameterField
        List<SortBy.Direction> direction;
        @ParameterField
        Optional<Lambda> delta;
        @ParameterField
        Optional<String> deltaAttribute = Optional.of("delta");
        @ParameterField
        Optional<String> deltaType;
        public RealizationInput rInput;
    }

    static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem deltaAttributeAlreadyExists(String var1, Struct var2);

        public Problem deltaTypeDifferentToActual(Type var1, Type var2);
    }

    static class InMemorySortCollector
    implements Collector<List<Tuple>> {
        private final Struct sourceType;
        private final Struct producedType;
        private final Comparator<Tuple> comparator;
        final Optional<RealizedExpression> deltaExpression;
        private final boolean cascade;

        public List<Tuple> newAccumulator() {
            return Lists.newArrayList();
        }

        public void accumulate(List<Tuple> accumulator, Tuple tuple) {
            accumulator.add(tuple);
        }

        public List<Tuple> combine(List<Tuple> lhs, List<Tuple> rhs) {
            return ListUtils.concat(lhs, rhs);
        }

        public Optional<Long> size(List<Tuple> accumulator) {
            return Optional.of(Long.valueOf(accumulator.size()));
        }

        public TupleIterator process(List<Tuple> accumulator) {
            accumulator.sort(this.comparator);
            if (this.deltaExpression.isPresent()) {
                ArrayList accumulatorWithDeltas = Lists.newArrayListWithCapacity((int)accumulator.size());
                RealizedExpression deltaExpr = this.deltaExpression.get();
                Struct deltaInputType = (Struct)deltaExpr.getInputType().find(Struct.class).get();
                Tuple previous = null;
                for (Tuple current : accumulator) {
                    Tuple deltaInput = Tuple.ofValues((Struct)deltaInputType, (Object[])new Object[]{previous, current});
                    Object delta = deltaExpr.evaluate((Object)deltaInput);
                    Tuple currentWithDelta = new Tuple(this.producedType);
                    currentWithDelta.setAll(current);
                    currentWithDelta.set(this.producedType.size() - 1, delta);
                    accumulatorWithDeltas.add(currentWithDelta);
                    previous = this.cascade ? currentWithDelta : current;
                }
                return this.getTupleIterator(accumulatorWithDeltas);
            }
            return this.getTupleIterator(accumulator);
        }

        private TupleIterator getTupleIterator(List<Tuple> list) {
            ArrayList<Tuple> copy = new ArrayList<Tuple>(list);
            Collections.reverse(copy);
            final ListIterator iterator = copy.listIterator(copy.size());
            return new TupleIterator(){

                public Tuple next() {
                    return (Tuple)iterator.previous();
                }

                public void remove() {
                    iterator.remove();
                }

                public boolean hasNext() {
                    return iterator.hasPrevious();
                }
            };
        }

        public Class<List<Tuple>> getAccumulatorClass() {
            Class<List> list = List.class;
            return list;
        }

        @Generated
        public InMemorySortCollector(Struct sourceType, Struct producedType, Comparator<Tuple> comparator, Optional<RealizedExpression> deltaExpression, boolean cascade) {
            this.sourceType = sourceType;
            this.producedType = producedType;
            this.comparator = comparator;
            this.deltaExpression = deltaExpression;
            this.cascade = cascade;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }
}

