/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.projection.FlatProjector;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.ProjectionStep;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;

public class SegmentStep
extends BaseStep<Parameters> {
    public SegmentStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        Struct sourceType = parameters.input.getProduces();
        HashSet seen = Sets.newHashSet();
        ArrayList problems = Lists.newArrayList();
        ArrayList segmentMappers = Lists.newArrayList();
        Struct projected = parameters.segmented.asStruct();
        for (Struct.StructMember segment : projected.getMembers()) {
            boolean targetNullable = Nullable.is((Type)segment.getType());
            Struct segmentType = segment.getType().asStruct();
            ArrayList attributeMappers = Lists.newArrayList();
            for (Struct.StructMember member : segmentType.getMembers()) {
                boolean nullable = Nullable.is((Type)member.getType());
                if (sourceType.hasMember(member.getKey())) {
                    if (sourceType.getEntry(member.getKey()).getType().getUnwrappedType() instanceof Struct) {
                        problems.add(Problem.error((String)"Source attribute '%s' is a struct", (Object[])new Object[]{member.getKey()}));
                    }
                } else if (!nullable && !parameters.allowMissingAttributes) {
                    problems.add(Problem.error((String)"Segment '%s' requires attribute '%s' which does not exist in input %s", (Object[])new Object[]{segment.getKey(), member.getKey(), sourceType}));
                }
                if (!seen.add(member.getKey())) {
                    problems.add(Problem.error((String)"Segment '%s' contains attribute '%s' which is used in other segments", (Object[])new Object[]{segment.getKey(), member.getKey()}));
                }
                if (member.getType().getUnwrappedType() instanceof Struct) {
                    problems.add(Problem.error((String)"Segment '%s' contains nested structs in '%s'", (Object[])new Object[]{segment.getKey(), member.getKey()}));
                }
                attributeMappers.add(this.attributeMapper(sourceType, member));
            }
            segmentMappers.add(this.segmentBuilder(segmentType, attributeMappers, targetNullable));
        }
        if (!problems.isEmpty()) {
            return ResultOrProblems.failed((List)problems);
        }
        return ResultOrProblems.of((Object)new SegmentFlatProjector(sourceType, projected, this.resultBuilder(projected, segmentMappers), parameters.skipInvalid));
    }

    private Function<Tuple, Object> attributeMapper(Struct sourceType, Struct.StructMember targetMember) {
        Type targetType = targetMember.getType();
        Optional sourceMember = sourceType.getMember(targetMember.getKey());
        if (!sourceMember.isPresent()) {
            return t -> null;
        }
        boolean targetNullable = Nullable.is((Type)targetType);
        boolean targetText = targetType instanceof Text;
        return t -> {
            Object value = t.fetch((Struct.StructMember)sourceMember.get());
            if ("".equals(value) && targetNullable && !targetText) {
                return null;
            }
            try {
                return targetType.coerce(value);
            }
            catch (CoercionException e) {
                throw new CoercionException(e.getValue(), e.getType(), "Value '%s' from source attribute %s could not be converted to type %s - %s", new Object[]{value, ((Struct.StructMember)sourceMember.get()).getKey(), targetType, e.getMessage()});
            }
        };
    }

    private Function<Tuple, Tuple> segmentBuilder(Struct segmentType, List<Function<Tuple, Object>> attributeMappers, boolean segmentNullable) {
        return source -> {
            try {
                Object[] values = new Object[attributeMappers.size()];
                for (int i = 0; i < attributeMappers.size(); ++i) {
                    values[i] = ((Function)attributeMappers.get(i)).apply(source);
                }
                return Tuple.ofValues((Struct)segmentType, (Object[])values);
            }
            catch (CoercionException e) {
                if (segmentNullable) {
                    return null;
                }
                throw e;
            }
        };
    }

    private Function<Tuple, Tuple> resultBuilder(Struct resultType, List<Function<Tuple, Tuple>> segmentMappers) {
        return source -> {
            Object[] values = new Object[segmentMappers.size()];
            for (int i = 0; i < segmentMappers.size(); ++i) {
                values[i] = ((Function)segmentMappers.get(i)).apply(source);
            }
            return Tuple.ofValues((Struct)resultType, (Object[])values);
        };
    }

    public static class Parameters
    extends ProjectionStep.ProjectionParameters {
        @ParameterField
        Type segmented;
        @ParameterField
        boolean skipInvalid;
        @ParameterField
        private boolean allowMissingAttributes;
    }

    private static class SegmentFlatProjector
    implements FlatProjector {
        private final Struct sourceType;
        private final Struct producedType;
        private final Function<Tuple, Tuple> tupleMapper;
        private final boolean skipInvalid;

        public TupleIterator apply(Tuple source) {
            try {
                Tuple result = this.tupleMapper.apply(source);
                return TupleIterator.singleton((Tuple)result);
            }
            catch (Exception e) {
                if (this.skipInvalid) {
                    return TupleIterator.EMPTY;
                }
                throw e;
            }
        }

        @Generated
        public SegmentFlatProjector(Struct sourceType, Struct producedType, Function<Tuple, Tuple> tupleMapper, boolean skipInvalid) {
            this.sourceType = sourceType;
            this.producedType = producedType;
            this.tupleMapper = tupleMapper;
            this.skipInvalid = skipInvalid;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }
}

