/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Project;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.output.Format;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.SinkConstructor;
import nz.org.riskscape.engine.pipeline.sink.SaveSinkConstructor;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class SaveStep
extends BaseStep<Params> {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public SaveStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<SinkConstructor> realize(Params parameters) {
        return this.buildFormatOptions(parameters).map(options -> new SaveSinkConstructor(parameters, (Optional<? extends Format.FormatOptions>)options));
    }

    private ResultOrProblems<Optional<? extends Format.FormatOptions>> buildFormatOptions(Params parameters) {
        boolean noOptions;
        BindingContext context = parameters.input.getBindingContext();
        boolean bl = noOptions = parameters.options.isEmpty() || parameters.options.get().getMembers().isEmpty();
        if (parameters.format.isEmpty()) {
            if (noOptions) {
                return ResultOrProblems.of(Optional.empty());
            }
            return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.optionsWithNoFormat()});
        }
        Format format = parameters.format.get();
        JavaParameterSet parameterSet = JavaParameterSet.fromBindingClass((Class)format.getWriterOptionsClass());
        List required = format.getRequiredOptions(context);
        if (noOptions) {
            if (!required.isEmpty()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.optionsRequired(format, required)});
            }
            return ResultOrProblems.of(Optional.empty());
        }
        HashMap<String, List<Expression>> paramMap = new HashMap<String, List<Expression>>();
        for (StructDeclaration.Member member : parameters.options.get().getMembers()) {
            String memberName = (String)member.getName().orElseThrow();
            Object value = member.getExpression();
            if (value instanceof Constant) {
                Constant constant = (Constant)value;
                if (parameterSet.contains(memberName) && !Expression.class.isAssignableFrom(parameterSet.get(memberName).getType())) {
                    value = ((RealizedExpression)parameters.input.getRealizationContext().getExpressionRealizer().realizeConstant((Expression)constant).get()).evaluate((Object)Tuple.EMPTY_TUPLE);
                }
            }
            if (value instanceof List) {
                List list = (List)value;
                paramMap.put(memberName, list);
                continue;
            }
            paramMap.put(memberName, List.of(value));
        }
        return format.buildOptions(paramMap, context, parameters.step.getProduces()).map(built -> Optional.of(built));
    }

    public static class Params {
        @ParameterField
        public Optional<String> name = Optional.empty();
        @ParameterField
        public Optional<Format> format = Optional.empty();
        @ParameterField
        public Optional<StructDeclaration> options = Optional.empty();
        @Input
        public RealizedStep step;
        public RealizationInput input;
        public Project project;

        public Project getProject() {
            if (this.input != null) {
                return this.input.getBindingContext().getProject();
            }
            return this.project;
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem optionsWithNoFormat();

        public Problem optionsRequired(Format var1, List<String> var2);
    }
}

