/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.ParamProblems;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.bind.ParameterSet;
import nz.org.riskscape.engine.i18n.RiskscapeMessage;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedPipeline;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.pipeline.Step;
import nz.org.riskscape.engine.projection.NestMembersProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.relation.IteratorRelation;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Text;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public class RelationInputStep
extends BaseStep<Parameters> {
    public static Step canned(final Relation relation) {
        return new Step(){

            public String getId() {
                return "no-id";
            }

            public RealizedPipeline realize(RealizationInput input) {
                return input.getRealizedPipeline().add(input.newPrototypeStep().realizedBy((Step)this).withResult((Realized)relation));
            }

            public Range<Integer> getInputArity() {
                return null;
            }

            public RiskscapeMessage getDescription() {
                return null;
            }

            public ParameterSet getParameterSet() {
                return ParameterSet.EMPTY;
            }
        };
    }

    public static RealizedStep realized(Relation relation) {
        return RealizedStep.named((String)"input").withResult((Realized)relation);
    }

    public static RealizedStep realized(Relation relation, String nestName) {
        return RelationInputStep.realized((Relation)relation.project((Projection)new NestMembersProjection(nestName)).get());
    }

    public RelationInputStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        return ProblemException.catching(probs -> this.realizeThrowing(parameters, probs));
    }

    public Realized realizeThrowing(Parameters parameters, List<Problem> warnings) throws ProblemException {
        Expression relationExpr = parameters.relation.orElse(null);
        final Expression constantValue = parameters.value.orElse(null);
        if (relationExpr != null) {
            String relationToBind = relationExpr.toSource();
            RealizedExpression realized = (RealizedExpression)parameters.input.getRealizationContext().getExpressionRealizer().realizeConstant(relationExpr).getOrThrow();
            if (realized.getResultType().isA(Text.class)) {
                relationToBind = realized.evaluate((Object)Tuple.EMPTY_TUPLE).toString();
            }
            Relation relation = (Relation)parameters.input.getBindingContext().bind((Object)relationToBind, Relation.class).drainWarnings(warnings::add).getOrThrow(Problems.foundWith((Object)"relation", (Problem[])new Problem[0]));
            if (constantValue != null) {
                throw new ProblemException((Problems)ParamProblems.get().mutuallyExclusive("relation", "value"));
            }
            if (parameters.limit.isPresent()) {
                relation = relation.limit(parameters.limit.get().longValue());
            }
            if (parameters.offset.isPresent()) {
                relation = relation.offset(parameters.offset.get().longValue());
            }
            if (parameters.name.isPresent()) {
                return (Realized)relation.project((Projection)new NestMembersProjection(parameters.name.get())).drainWarnings(warnings::add).getOrThrow();
            }
            return relation;
        }
        if (constantValue == null) {
            throw new ProblemException((Problems)ParamProblems.oneOfTheseRequired((String[])new String[]{"relation", "value"}));
        }
        final RealizedExpression realized = (RealizedExpression)parameters.input.getRealizationContext().getExpressionRealizer().realizeConstant(constantValue).drainWarnings(warnings::add).getOrThrow(Problems.foundWith((Object)"value", (Problem[])new Problem[0]));
        if (parameters.limit.isPresent()) {
            warnings.add(ParamProblems.get().ignored("limit"));
        }
        if (parameters.offset.isPresent()) {
            warnings.add(ParamProblems.get().ignored("offset"));
        }
        final String name = parameters.name.orElse(null);
        Type notNullType = Nullable.strip((Type)realized.getResultType());
        final Struct type = name != null ? Struct.of((String)name, (Type)notNullType) : notNullType.asStruct();
        return new IteratorRelation(type, () -> new PeekingTupleIterator(){
            boolean consumed = false;

            protected String getSource() {
                return constantValue.toSource();
            }

            protected Tuple get() {
                if (this.consumed) {
                    return null;
                }
                this.consumed = true;
                Object result = realized.evaluate((Object)Tuple.EMPTY_TUPLE);
                if (result != null) {
                    if (name != null) {
                        return Tuple.ofValues((Struct)type, (Object[])new Object[]{result});
                    }
                    if (result instanceof Tuple) {
                        return (Tuple)result;
                    }
                    return Tuple.ofValues((Struct)type, (Object[])new Object[]{result});
                }
                return null;
            }
        });
    }

    @Override
    public String getId() {
        return "input";
    }

    public static void setInput(Relation relation, String stepName, Map<String, List<?>> pipelineParameters) {
        pipelineParameters.put(stepName + ".relation", Arrays.asList(relation));
    }

    public static class Parameters {
        @ParameterField
        public Optional<Expression> relation;
        @ParameterField
        public Optional<String> name;
        @ParameterField
        public Optional<Long> limit = Optional.empty();
        @ParameterField
        public Optional<Long> offset = Optional.empty();
        @ParameterField
        public Optional<Expression> value;
        public RealizationInput input;
    }
}

