/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.join.DefaultJoiner;
import nz.org.riskscape.engine.join.ExpressionJoinCondition;
import nz.org.riskscape.engine.join.HashIndexer;
import nz.org.riskscape.engine.join.JoinCondition;
import nz.org.riskscape.engine.join.JoinIndexer;
import nz.org.riskscape.engine.join.JoinType;
import nz.org.riskscape.engine.join.Joiner;
import nz.org.riskscape.engine.join.NoIndexIndexer;
import nz.org.riskscape.engine.join.SpatialIndexer;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;

public class JoinStep
extends BaseStep<Parameters> {
    public static final List<JoinIndexer.Constructor> INDEX_CONSTRUCTORS = Lists.newArrayList((Object[])new JoinIndexer.Constructor[]{SpatialIndexer.CONSTRUCTOR, HashIndexer.CONSTRUCTOR, NoIndexIndexer.CONSTRUCTOR});

    public JoinStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        ExpressionRealizer expressionRealizer = parameters.rInput.getExecutionContext().getExpressionRealizer();
        return Joiner.build(parameters.lhs.getProduces(), parameters.rhs.getProduces(), JoinCondition.CARTESIAN, parameters.joinType).flatMap(join -> ExpressionJoinCondition.realize(parameters.on, join.getJoinedType(), expressionRealizer).flatMap(on -> ResultOrProblems.of((Object)new DefaultJoiner(join.withJoinConditon((JoinCondition)on), INDEX_CONSTRUCTORS, expressionRealizer, parameters.initialIndexSize))));
    }

    public static class Parameters {
        @ParameterField
        public Expression on;
        @ParameterField
        public JoinType joinType = JoinType.INNER;
        @ParameterField
        public Optional<Integer> initialIndexSize;
        @Input
        public RealizedStep lhs;
        @Input
        public RealizedStep rhs;
        public RealizationInput rInput;
    }
}

