/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.restriction.DefaultRestrictor;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Constant;
import nz.org.riskscape.rl.ast.Expression;

public class FilterStep
extends BaseStep<Parameters> {
    public FilterStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Parameters parameters) {
        try {
            Struct inputType = parameters.input.getProduces();
            return parameters.rInput.getExecutionContext().getExpressionRealizer().realize((Type)inputType, parameters.filter).flatMap(re -> {
                if (Nullable.strip((Type)re.getResultType()) != Types.BOOLEAN) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Expression '%s' does not produce a boolean", (Object[])new Object[]{re.getExpression().toSource()})});
                }
                return ResultOrProblems.of((Object)new DefaultRestrictor(inputType, t -> {
                    Object result = re.evaluate(t);
                    return result == null ? false : (Boolean)result;
                }, () -> re.close()));
            });
        }
        catch (Exception e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)e, (String)"could not realize filter, cause: %s", (Object[])new Object[]{e.getMessage()})});
        }
    }

    public static class Parameters {
        @ParameterField
        public Expression filter = Constant.TRUE;
        @Input
        public RealizedStep input;
        public RealizationInput rInput;
    }
}

