/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.steps;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.HasMeter;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.IntersectionIndex;
import nz.org.riskscape.engine.geo.OverlayOperations;
import nz.org.riskscape.engine.pipeline.Collector;
import nz.org.riskscape.engine.pipeline.RealizationInput;
import nz.org.riskscape.engine.pipeline.Realized;
import nz.org.riskscape.engine.pipeline.RealizedStep;
import nz.org.riskscape.engine.projection.Projector;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.steps.BaseStep;
import nz.org.riskscape.engine.steps.Input;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.TokenTypes;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.PropertyAccess;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;

public class EnlargeStep
extends BaseStep<Params> {
    public static final String PROCESS_METRIC_NAME = "process";

    public EnlargeStep(Engine engine) {
        super(engine);
    }

    @Override
    public ResultOrProblems<? extends Realized> realize(Params parameters) {
        Struct inputType = parameters.input.getProduces();
        RealizationContext context = parameters.rInput.getExecutionContext().getRealizationContext();
        ExpressionRealizer realizer = context.getExpressionRealizer();
        BindingContext bindingContext = parameters.rInput.getBindingContext();
        return ProblemException.catching(() -> {
            List<String> geomPath;
            RealizedExpression distanceExpression = (RealizedExpression)realizer.realize((Type)inputType, parameters.distance).getOrThrow();
            if (!distanceExpression.getResultType().isNumeric()) {
                throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)parameters.distance, (Type)Types.FLOATING, distanceExpression.getResultType()));
            }
            if (parameters.geomExpression.isPresent()) {
                geomPath = this.getMembersFromExpression(parameters.geomExpression.get(), inputType, realizer);
            } else {
                geomPath = this.findFirstGeometry(inputType);
                if (geomPath.isEmpty()) {
                    throw new ProblemException((Problems)new Problem(Problem.Severity.ERROR, (ProblemCode)StandardCodes.GEOMETRY_REQUIRED, new Object[]{inputType}));
                }
            }
            String bufferExpression = String.format("buffer(%s, %s, options: %s)", geomPath.stream().map(i -> TokenTypes.quoteIdent((String)i)).collect(Collectors.joining(".")), parameters.distance.toSource(), parameters.mode.orElse((EnlargeMode)EnlargeMode.ROUND).mode);
            RealizedExpression rBufferExpr = (RealizedExpression)realizer.realize((Type)inputType, ExpressionParser.INSTANCE.parse(bufferExpression)).getOrThrow();
            StructMemberAccessExpression geomAccessor = (StructMemberAccessExpression)StructMemberAccessExpression.build((Type)inputType, geomPath).getOrThrow();
            Struct targetType = (Struct)this.getTargetType(inputType, geomPath).findAllowNull(Struct.class).get();
            EnlargeGeometryProjector enlargingProjector = new EnlargeGeometryProjector(inputType, targetType, geomAccessor, rBufferExpr);
            if (!parameters.removeOverlaps.orElse(false).booleanValue()) {
                return enlargingProjector;
            }
            StructMemberAccessExpression targetGeomAccessor = (StructMemberAccessExpression)StructMemberAccessExpression.build((Type)targetType, geomPath).getOrThrow();
            return new EnlargingCollector(inputType, targetType, enlargingProjector, targetGeomAccessor, context.getProject().getSridSet());
        });
    }

    private Type getTargetType(Struct inputType, List<String> geomPath) {
        Struct.StructMember member = inputType.getEntry(geomPath.get(0));
        boolean nullableMember = Nullable.is((Type)member.getType());
        Optional isStruct = member.getType().findAllowNull(Struct.class);
        if (isStruct.isPresent()) {
            Type amended = this.getTargetType((Struct)isStruct.get(), geomPath.subList(1, geomPath.size()));
            return inputType.replace(member.getKey(), Nullable.ifTrue((boolean)nullableMember, (Type)amended));
        }
        Optional referencedGeom = member.getType().findAllowNull(Referenced.class);
        Type amendedGeomType = referencedGeom.map(ref -> Referenced.of((Type)Types.GEOMETRY, (CoordinateReferenceSystem)ref.getCrs())).orElse((Type)Types.GEOMETRY);
        return inputType.replace(member.getKey(), Nullable.ifTrue((boolean)nullableMember, (Type)amendedGeomType));
    }

    private List<String> getMembersFromExpression(PropertyAccess geomExpression, Struct inputType, ExpressionRealizer realizer) throws ProblemException {
        if (geomExpression.getReceiver().isPresent()) {
            throw new ProblemException(new Problem[0]);
        }
        RealizedExpression expr = (RealizedExpression)realizer.realize((Type)inputType, (Expression)geomExpression).getOrThrow();
        ArrayList<String> members = new ArrayList<String>();
        Struct toAccess = inputType;
        for (int i = 0; i < geomExpression.getIdentifiers().size(); ++i) {
            Token identifier = (Token)geomExpression.getIdentifiers().get(i);
            Struct.StructMember member = toAccess.getEntry(identifier.getValue());
            members.add(member.getKey());
            Optional nestedStruct = member.getType().findAllowNull(Struct.class);
            if (!nestedStruct.isPresent()) continue;
            toAccess = (Struct)nestedStruct.get();
        }
        Optional isStruct = expr.getResultType().find(Struct.class);
        if (isStruct.isPresent()) {
            Struct struct = (Struct)isStruct.get();
            Struct.StructMember geometry = TupleUtils.findGeometryMember((Struct)struct, (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
            if (geometry == null) {
                throw new ProblemException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{struct}));
            }
            members.add(geometry.getKey());
        } else if (!expr.getResultType().find(Geom.class).isPresent()) {
            throw new ProblemException((Problems)TypeProblems.get().mismatch((Object)geomExpression, (Type)Types.GEOMETRY, expr.getResultType()));
        }
        return members;
    }

    List<String> findFirstGeometry(Struct struct) {
        for (Struct.StructMember member : struct.getMembers()) {
            List<String> nested;
            Optional geomType = member.getType().findAllowNull(Geom.class);
            if (geomType.isPresent()) {
                ArrayList<String> found = new ArrayList<String>();
                found.add(member.getKey());
                return found;
            }
            Optional structMember = member.getType().findAllowNull(Struct.class);
            if (!structMember.isPresent() || (nested = this.findFirstGeometry((Struct)structMember.get())).isEmpty()) continue;
            nested.add(0, member.getKey());
            return nested;
        }
        return Collections.emptyList();
    }

    public static class Params {
        @ParameterField
        Expression distance;
        @ParameterField
        Optional<PropertyAccess> geomExpression;
        @ParameterField
        Optional<EnlargeMode> mode;
        @ParameterField
        Optional<Boolean> removeOverlaps;
        @Input
        public RealizedStep input;
        public RealizationInput rInput;
    }

    public static enum EnlargeMode {
        ROUND("{vertex: 'round', cap: 'round'}"),
        BEVELED_SQUARE("{vertex: 'bevel', cap: 'square'}"),
        BEVELED_FLAT("{vertex: 'bevel', cap: 'flat'}"),
        MITRED_SQUARE("{vertex: 'mitre', cap: 'square'}"),
        MITRED_FLAT("{vertex: 'mitre', cap: 'flat'}");

        public final String mode;

        @Generated
        private EnlargeMode(String mode) {
            this.mode = mode;
        }
    }

    static class EnlargeGeometryProjector
    implements Projector {
        private final Struct sourceType;
        private final Struct producedType;
        private final StructMemberAccessExpression geomAccessor;
        private final RealizedExpression bufferExpression;

        public Tuple apply(Tuple t) {
            Object original = this.geomAccessor.evaluate((Object)t);
            Object buffered = this.bufferExpression.evaluate((Object)t);
            Tuple clone = t.clone();
            if (original != null) {
                this.geomAccessor.setValue(clone, buffered);
            }
            Tuple projected = (Tuple)this.producedType.coerce((Object)clone);
            return projected;
        }

        @Generated
        public EnlargeGeometryProjector(Struct sourceType, Struct producedType, StructMemberAccessExpression geomAccessor, RealizedExpression bufferExpression) {
            this.sourceType = sourceType;
            this.producedType = producedType;
            this.geomAccessor = geomAccessor;
            this.bufferExpression = bufferExpression;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }

    static class EnlargingCollector
    implements Collector<AccumInstance>,
    HasMeter {
        private final Class<AccumInstance> accumulatorClass = AccumInstance.class;
        private final Struct sourceType;
        private final Struct producedType;
        private final Projector enlargingProjector;
        private final StructMemberAccessExpression geomAccessor;
        private final SRIDSet sridSet;
        private final MetricRegistry metrics = new MetricRegistry();
        private final Timer processTimer;
        private final List<String> progressMetricNames = Lists.newArrayList((Object[])new String[]{"process"});

        EnlargingCollector(Struct sourceType, Struct targetType, Projector enlargingProjector, StructMemberAccessExpression geomAccessor, SRIDSet sridSet) {
            this.sourceType = sourceType;
            this.producedType = targetType;
            this.enlargingProjector = enlargingProjector;
            this.geomAccessor = geomAccessor;
            this.sridSet = sridSet;
            this.processTimer = this.metrics.timer(EnlargeStep.PROCESS_METRIC_NAME);
        }

        public AccumInstance newAccumulator() {
            return new AccumInstance(this.enlargingProjector);
        }

        public void accumulate(AccumInstance accumulator, Tuple tuple) {
            accumulator.accumulate(tuple);
        }

        public AccumInstance combine(AccumInstance lhs, AccumInstance rhs) {
            return lhs.combine(rhs);
        }

        public TupleIterator process(AccumInstance accumulator) {
            OverlayOperations overlayOps = OverlayOperations.get();
            List<Tuple> tuples = accumulator.items;
            IntersectionIndex index = IntersectionIndex.withDefaultOptions(this.geomAccessor, this.sridSet);
            tuples.stream().forEach(t -> index.insert((Tuple)t));
            index.build();
            for (Tuple indexed : tuples) {
                long start = System.nanoTime();
                Geometry indexedGeom = this.geomAccessor.evaluate(indexed, Geometry.class);
                GeometryFamily indexedGeomFamily = GeometryFamily.from((Geometry)indexedGeom);
                boolean indexedGeomUpdated = false;
                boolean removeOverlapFromLHS = false;
                for (Pair<Geometry, Tuple> potentialIntersection : index.findIntersections(indexedGeom)) {
                    Geometry differenceFrom;
                    Geometry difference;
                    Geometry intersectingGeom;
                    Geometry actualIntersection;
                    if (indexed.equals(potentialIntersection.getRight()) || (actualIntersection = GeometryUtils.removeNonFamilyMembers((Geometry)overlayOps.intersection(indexedGeom, intersectingGeom = this.geomAccessor.evaluate(potentialIntersection.getRight(), Geometry.class)), (GeometryFamily)indexedGeomFamily)).isEmpty() || (difference = GeometryUtils.removeNonFamilyMembers((Geometry)overlayOps.difference(differenceFrom = (removeOverlapFromLHS = !removeOverlapFromLHS) ? indexedGeom : intersectingGeom, actualIntersection), (GeometryFamily)indexedGeomFamily)).isEmpty()) continue;
                    if (removeOverlapFromLHS) {
                        indexedGeomUpdated = true;
                        indexedGeom = difference;
                        continue;
                    }
                    this.geomAccessor.setValue((Tuple)potentialIntersection.getRight(), difference);
                }
                if (indexedGeomUpdated) {
                    this.geomAccessor.setValue(indexed, indexedGeom);
                }
                this.processTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
            return TupleIterator.wrapped(tuples.iterator(), Optional.empty());
        }

        public MetricRegistry getRegistry() {
            return this.metrics;
        }

        public List<String> getProgressMetricNames() {
            return this.progressMetricNames;
        }

        @Generated
        public Class<AccumInstance> getAccumulatorClass() {
            return this.accumulatorClass;
        }

        @Generated
        public Struct getSourceType() {
            return this.sourceType;
        }

        @Generated
        public Struct getProducedType() {
            return this.producedType;
        }
    }

    static class AccumInstance {
        private final Projector enlargingProjector;
        private final List<Tuple> items = new ArrayList<Tuple>();

        public void accumulate(Tuple tuple) {
            Tuple enlarged = (Tuple)this.enlargingProjector.apply((Object)tuple);
            this.items.add(enlarged);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public AccumInstance combine(AccumInstance rhs) {
            if (rhs.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return rhs;
            }
            AccumInstance combined = new AccumInstance(this.enlargingProjector);
            combined.items.addAll(this.items);
            combined.items.addAll(rhs.items);
            return combined;
        }

        @Generated
        public AccumInstance(Projector enlargingProjector) {
            this.enlargingProjector = enlargingProjector;
        }
    }
}

